/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IAPQU_H
#define _IAPQU_H

#include <iarstrct.h>
#include <iaorder.h>
#include <iiaksb.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key>
class IAPriorityQueue :
  public IARestrictedAccessCollection <Element> {

  typedef  IARestrictedAccessCollection <Element> Inherited;

  typedef  IAKeySortedBagImpl Implementation;

public:

           IAPriorityQueue
                            (INotifier&);

          ~IAPriorityQueue
                            ();

  long     compare          (IAPriorityQueue <Element, Key> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
  IBoolean containsAllKeysFrom
                            (IARestrictedAccessCollection
                              <Element> const&) const;

  IBoolean containsElementWithKey
                            (Key const&) const;

  void     dequeue          ();

  void     dequeue          (Element&);

  Element const&
           elementWithKey   (Key const&) const;

  void     enqueue          (Element const&);

  void     enqueue          (Element const&, ICursor&);

  Key const&
           key              (Element const&) const;

  IBoolean locateElementWithKey
                            (Key const&, ICursor&) const;

  IBoolean locateNextElementWithKey
                            (Key const&, ICursor&) const;

  IBoolean locateOrAddElementWithKey
                            (Element const&);

  IBoolean locateOrAddElementWithKey
                            (Element const&, ICursor&);

  INumber  numberOfDifferentKeys
                            () const;

  INumber  numberOfElementsWithKey
                            (Key const&) const;

  void     removeFirst      ();

  IBoolean setToNextWithDifferentKey
                            (ICursor&) const;

protected:

           IAPriorityQueue
                            ();

           IAPriorityQueue
                            (IAPriorityQueue <Element, Key> const&);

private:

  static
  Implementation&
           ImplOf           (IAPriorityQueue <Element, Key> const&);


};

#include <iapqu.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
