/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IAPriorityQueue
// ---

template <class Element, class Key>
inline
IAPriorityQueue <Element, Key>::
IAPriorityQueue (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element, class Key>
inline
IAPriorityQueue <Element, Key>::
~IAPriorityQueue ()
{
}

template <class Element, class Key>
inline long
IAPriorityQueue <Element, Key>::
compare (IAPriorityQueue <Element, Key> const& collection,
         long (*compFunc) (Element const&, Element const&)) const
{ return ImplOf (*this).
    Compare (ImplOf (collection), (ICompFunc)compFunc, 0);
}

template <class Element, class Key>
inline IBoolean
IAPriorityQueue <Element, Key>::
containsAllKeysFrom
  (IARestrictedAccessCollection <Element> const& collection) const
{ return ImplOf (*this).
    ContainsAllKeysFrom (Inherited::ImplOf (collection));
}

template <class Element, class Key>
inline IBoolean
IAPriorityQueue <Element, Key>::
containsElementWithKey (Key const& key) const
{ return ImplOf (*this).ContainsElementWithKey (&key);
}

template <class Element, class Key>
inline void
IAPriorityQueue <Element, Key>::
dequeue ()
{ ImplOf (*this).RemoveFirst ();
}

template <class Element, class Key>
inline void
IAPriorityQueue <Element, Key>::
dequeue (Element& element)
{ element = *(Element*) ImplOf (*this).First ();
  ImplOf (*this).RemoveFirst ();
}

template <class Element, class Key>
inline Element const&
IAPriorityQueue <Element, Key>::
elementWithKey (Key const& key) const
{ return *(Element const*) ImplOf (*this).ElementWithKey (&key);
}

template <class Element, class Key>
inline void
IAPriorityQueue <Element, Key>::
enqueue (Element const& element)
{ ImplOf (*this).Add (&element);
}

template <class Element, class Key>
inline void
IAPriorityQueue <Element, Key>::
enqueue (Element const& element, ICursor& cursor)
{ ImplOf (*this).Add (&element, CrsrImplOf (cursor));
}

template <class Element, class Key>
inline Key const&
IAPriorityQueue <Element, Key>::
key (Element const& element) const
{ return *(Key const*) ImplOf (*this).Key (&element);
}

template <class Element, class Key>
inline IBoolean
IAPriorityQueue <Element, Key>::
locateElementWithKey (Key const& key, ICursor& cursor) const
{ return ImplOf (*this).
    LocateElementWithKey (&key, CrsrImplOf (cursor));
}

template <class Element, class Key>
inline IBoolean
IAPriorityQueue <Element, Key>::
locateNextElementWithKey (Key const& key, ICursor& cursor) const
{ return ImplOf (*this).
    LocateNextElementWithKey (&key, CrsrImplOf (cursor));
}

template <class Element, class Key>
inline IBoolean
IAPriorityQueue <Element, Key>::
locateOrAddElementWithKey (Element const& element)
{ return ImplOf (*this).LocateOrAddElementWithKey (&element);
}

template <class Element, class Key>
inline IBoolean
IAPriorityQueue <Element, Key>::
locateOrAddElementWithKey (Element const& element, ICursor& cursor)
{ return ImplOf (*this).
    LocateOrAddElementWithKey (&element, CrsrImplOf (cursor));
}

template <class Element, class Key>
inline INumber
IAPriorityQueue <Element, Key>::
numberOfDifferentKeys () const
{ return ImplOf (*this).NumberOfDifferentKeys ();
}

template <class Element, class Key>
inline INumber
IAPriorityQueue <Element, Key>::
numberOfElementsWithKey (Key const& key) const
{ return ImplOf (*this).NumberOfElementsWithKey (&key);
}

template <class Element, class Key>
inline void
IAPriorityQueue <Element, Key>::
removeFirst ()
{ ImplOf (*this).RemoveFirst ();
}

template <class Element, class Key>
inline IBoolean
IAPriorityQueue <Element, Key>::
setToNextWithDifferentKey (ICursor& cursor) const
{ return ImplOf (*this).SetToNextWithDifferentKey (CrsrImplOf (cursor));
}

// protected members

template <class Element, class Key>
inline
IAPriorityQueue <Element, Key>::
IAPriorityQueue ()
{
}

template <class Element, class Key>
inline
IAPriorityQueue <Element, Key>::
IAPriorityQueue (IAPriorityQueue <Element, Key> const& collection)
: Inherited (collection)
{
}

// private members

template <class Element, class Key>
inline IAPriorityQueue <Element, Key>::Implementation&
IAPriorityQueue <Element, Key>::
ImplOf (IAPriorityQueue <Element, Key> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
