/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IAREL_H
#define _IAREL_H

#include <iaeqkey.h>
#include <iiarel.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key>
class IARelation :
  public IAEqualityKeyCollection <Element, Key> {

  typedef  IAEqualityKeyCollection <Element, Key> Inherited;

  typedef  IARelationImpl Implementation;

public:

           IARelation
                            (INotifier&);

          ~IARelation
                            ();

  void     addDifference    (IARelation <Element, Key> const&,
                             IARelation <Element, Key> const&); 

  void     addIntersection  (IARelation <Element, Key> const&,
                             IARelation <Element, Key> const&);

  void     addUnion         (IARelation <Element, Key> const&,
                             IARelation <Element, Key> const&);

  void     differenceWith   (IARelation <Element, Key> const&);

  void     intersectionWith (IARelation <Element, Key> const&);

  void     unionWith        (IARelation <Element, Key> const&);

  IBoolean operator==       (IARelation
                              <Element, Key> const&) const;

  IBoolean operator!=       (IARelation
                              <Element, Key> const&) const;

protected:

           IARelation
                            ();

           IARelation
                            (IARelation <Element, Key> const&);

  IBoolean locateNext       (Element const&, ICursor&) const;

  INumber  numberOfOccurrences
                            (Element const&) const;

  INumber  removeAllOccurrences
                            (Element const&);

private:

  static
  Implementation&
           ImplOf           (IARelation <Element, Key> const&);


};

#include <iarel.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
