/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IARelation
// ---

template <class Element, class Key>
inline
IARelation <Element, Key>::
IARelation (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element, class Key>
inline
IARelation <Element, Key>::
~IARelation ()
{
}

template <class Element, class Key>
inline void
IARelation <Element, Key>::
addDifference (IARelation <Element, Key> const& collection1,
               IARelation <Element, Key> const& collection2)
{ ImplOf (*this).
    AddDifference (ImplOf (collection1), ImplOf (collection2));
}

template <class Element, class Key>
inline void
IARelation <Element, Key>::
addIntersection (IARelation <Element, Key> const& collection1,
                 IARelation <Element, Key> const& collection2)
{ ImplOf (*this).
    AddIntersection (ImplOf (collection1), ImplOf (collection2));
}

template <class Element, class Key>
inline void
IARelation <Element, Key>::
addUnion (IARelation <Element, Key> const& collection1,
          IARelation <Element, Key> const& collection2)
{ ImplOf (*this).
    AddUnion (ImplOf (collection1), ImplOf (collection2));
}

template <class Element, class Key>
inline void
IARelation <Element, Key>::
differenceWith (IARelation <Element, Key> const& collection)
{ ImplOf (*this).Difference (ImplOf (collection));
}

template <class Element, class Key>
inline void
IARelation <Element, Key>::
intersectionWith (IARelation <Element, Key> const& collection)
{ ImplOf (*this).Intersection (ImplOf (collection));
}

template <class Element, class Key>
inline void
IARelation <Element, Key>::
unionWith (IARelation <Element, Key> const& collection)
{ ImplOf (*this).Union (ImplOf (collection));
}

template <class Element, class Key>
inline IBoolean
IARelation <Element, Key>::
operator== (IARelation <Element, Key> const& collection) const
{ return ImplOf (*this).operator== (ImplOf (collection));
}

template <class Element, class Key>
inline IBoolean
IARelation <Element, Key>::
operator!= (IARelation <Element, Key> const& collection) const
{ return ImplOf (*this).operator!= (ImplOf (collection));
}

// protected members

template <class Element, class Key>
inline
IARelation <Element, Key>::
IARelation ()
{
}

template <class Element, class Key>
inline
IARelation <Element, Key>::
IARelation (IARelation <Element, Key> const& collection)
: Inherited (collection)
{
}

template <class Element, class Key>
inline IBoolean
IARelation <Element, Key>::
locateNext (Element const& element, ICursor& cursor) const
{ return IAEqualityCollection <Element>::locateNext (element, cursor);
}

template <class Element, class Key>
inline INumber
IARelation <Element, Key>::
numberOfOccurrences (Element const& element) const
{ return IAEqualityCollection <Element>::numberOfOccurrences (element);
}

template <class Element, class Key>
inline INumber
IARelation <Element, Key>::
removeAllOccurrences (Element const& element)
{ return IAEqualityCollection <Element>::removeAllOccurrences (element);
}

// private members

template <class Element, class Key>
inline IARelation <Element, Key>::Implementation&
IARelation <Element, Key>::
ImplOf (IARelation <Element, Key> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
