/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IASB_H
#define _IASB_H

#include <iaeqsrt.h>
#include <iiasb.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
class IASortedBag :
  public IAEqualitySortedCollection <Element> {

  typedef  IAEqualitySortedCollection <Element> Inherited;

  typedef  IASortedBagImpl Implementation;

public:

           IASortedBag
                            (INotifier&);

          ~IASortedBag
                            ();

  void     addDifference    (IASortedBag <Element> const&,
                             IASortedBag <Element> const&); 

  void     addIntersection  (IASortedBag <Element> const&,
                             IASortedBag <Element> const&);

  void     addUnion         (IASortedBag <Element> const&,
                             IASortedBag <Element> const&);

  long     compare          (IASortedBag <Element> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
  void     differenceWith   (IASortedBag <Element> const&);

  void     intersectionWith (IASortedBag <Element> const&);

  INumber  numberOfDifferentElements
                            () const;

  IBoolean setToNextDifferentElement
                            (ICursor&) const;

  void     unionWith        (IASortedBag <Element> const&);

  IBoolean operator==       (IASortedBag
                              <Element> const&) const;

  IBoolean operator!=       (IASortedBag
                              <Element> const&) const;

protected:

           IASortedBag
                            ();

           IASortedBag
                            (IASortedBag <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IASortedBag <Element> const&);


};

#include <iasb.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
