/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IASEQ_H
#define _IASEQ_H

#include <iasqntl.h>
#include <iiaseq.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
class IASequence :
  public IASequentialCollection <Element> {

  typedef  IASequentialCollection <Element> Inherited;

  typedef  IASequenceImpl Implementation;

public:

           IASequence
                            (INotifier&);

          ~IASequence
                            ();

  long     compare          (IASequence <Element> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
protected:

           IASequence
                            ();

           IASequence
                            (IASequence <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IASequence <Element> const&);


};

#include <iaseq.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
