/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IASequence
// ---

template <class Element>
inline
IASequence <Element>::
IASequence (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element>
inline
IASequence <Element>::
~IASequence ()
{
}

template <class Element>
inline long
IASequence <Element>::
compare (IASequence <Element> const& collection,
         long (*compFunc) (Element const&, Element const&)) const
{ return ImplOf (*this).
    Compare (ImplOf (collection), (ICompFunc)compFunc, 0);
}

// protected members

template <class Element>
inline
IASequence <Element>::
IASequence ()
{
}

template <class Element>
inline
IASequence <Element>::
IASequence (IASequence <Element> const& collection)
: Inherited (collection)
{
}

// private members

template <class Element>
inline IASequence <Element>::Implementation&
IASequence <Element>::
ImplOf (IASequence <Element> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
