/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IASet
// ---

template <class Element>
inline
IASet <Element>::
IASet (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element>
inline
IASet <Element>::
~IASet ()
{
}

template <class Element>
inline void
IASet <Element>::
addDifference (IASet <Element> const& collection1,
               IASet <Element> const& collection2)
{ ImplOf (*this).
    AddDifference (ImplOf (collection1), ImplOf (collection2));
}

template <class Element>
inline void
IASet <Element>::
addIntersection (IASet <Element> const& collection1,
                 IASet <Element> const& collection2)
{ ImplOf (*this).
    AddIntersection (ImplOf (collection1), ImplOf (collection2));
}

template <class Element>
inline void
IASet <Element>::
addUnion (IASet <Element> const& collection1,
          IASet <Element> const& collection2)
{ ImplOf (*this).
    AddUnion (ImplOf (collection1), ImplOf (collection2));
}

template <class Element>
inline void
IASet <Element>::
differenceWith (IASet <Element> const& collection)
{ ImplOf (*this).Difference (ImplOf (collection));
}

template <class Element>
inline void
IASet <Element>::
intersectionWith (IASet <Element> const& collection)
{ ImplOf (*this).Intersection (ImplOf (collection));
}

template <class Element>
inline void
IASet <Element>::
unionWith (IASet <Element> const& collection)
{ ImplOf (*this).Union (ImplOf (collection));
}

template <class Element>
inline IBoolean
IASet <Element>::
operator== (IASet <Element> const& collection) const
{ return ImplOf (*this).operator== (ImplOf (collection));
}

template <class Element>
inline IBoolean
IASet <Element>::
operator!= (IASet <Element> const& collection) const
{ return ImplOf (*this).operator!= (ImplOf (collection));
}

// protected members

template <class Element>
inline
IASet <Element>::
IASet ()
{
}

template <class Element>
inline
IASet <Element>::
IASet (IASet <Element> const& collection)
: Inherited (collection)
{
}

template <class Element>
inline IBoolean
IASet <Element>::
locateNext (Element const& element, ICursor& cursor) const
{ return IAEqualityCollection <Element>::locateNext (element, cursor);
}

template <class Element>
inline INumber
IASet <Element>::
numberOfOccurrences (Element const& element) const
{ return IAEqualityCollection <Element>::numberOfOccurrences (element);
}

template <class Element>
inline INumber
IASet <Element>::
removeAllOccurrences (Element const& element)
{ return IAEqualityCollection <Element>::removeAllOccurrences (element);
}

// private members

template <class Element>
inline IASet <Element>::Implementation&
IASet <Element>::
ImplOf (IASet <Element> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
