/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IASortedMap
// ---

template <class Element, class Key>
inline
IASortedMap <Element, Key>::
IASortedMap (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element, class Key>
inline
IASortedMap <Element, Key>::
~IASortedMap ()
{
}

template <class Element, class Key>
inline void
IASortedMap <Element, Key>::
addDifference (IASortedMap <Element, Key> const& collection1,
               IASortedMap <Element, Key> const& collection2)
{ ImplOf (*this).
    AddDifference (ImplOf (collection1), ImplOf (collection2));
}

template <class Element, class Key>
inline void
IASortedMap <Element, Key>::
addIntersection (IASortedMap <Element, Key> const& collection1,
                 IASortedMap <Element, Key> const& collection2)
{ ImplOf (*this).
    AddIntersection (ImplOf (collection1), ImplOf (collection2));
}

template <class Element, class Key>
inline void
IASortedMap <Element, Key>::
addUnion (IASortedMap <Element, Key> const& collection1,
          IASortedMap <Element, Key> const& collection2)
{ ImplOf (*this).
    AddUnion (ImplOf (collection1), ImplOf (collection2));
}

template <class Element, class Key>
inline long
IASortedMap <Element, Key>::
compare (IASortedMap <Element, Key> const& collection,
         long (*compFunc) (Element const&, Element const&)) const
{ return ImplOf (*this).
    Compare (ImplOf (collection), (ICompFunc)compFunc, 0);
}

template <class Element, class Key>
inline void
IASortedMap <Element, Key>::
differenceWith (IASortedMap <Element, Key> const& collection)
{ ImplOf (*this).Difference (ImplOf (collection));
}

template <class Element, class Key>
inline void
IASortedMap <Element, Key>::
intersectionWith (IASortedMap <Element, Key> const& collection)
{ ImplOf (*this).Intersection (ImplOf (collection));
}

template <class Element, class Key>
inline void
IASortedMap <Element, Key>::
unionWith (IASortedMap <Element, Key> const& collection)
{ ImplOf (*this).Union (ImplOf (collection));
}

template <class Element, class Key>
inline IBoolean
IASortedMap <Element, Key>::
operator== (IASortedMap <Element, Key> const& collection) const
{ return ImplOf (*this).operator== (ImplOf (collection));
}

template <class Element, class Key>
inline IBoolean
IASortedMap <Element, Key>::
operator!= (IASortedMap <Element, Key> const& collection) const
{ return ImplOf (*this).operator!= (ImplOf (collection));
}

// protected members

template <class Element, class Key>
inline
IASortedMap <Element, Key>::
IASortedMap ()
{
}

template <class Element, class Key>
inline
IASortedMap <Element, Key>::
IASortedMap (IASortedMap <Element, Key> const& collection)
: Inherited (collection)
{
}

template <class Element, class Key>
inline INumber
IASortedMap <Element, Key>::
numberOfDifferentKeys () const
{ return IAKeyCollection <Element, Key>::numberOfDifferentKeys ();
}

template <class Element, class Key>
inline INumber
IASortedMap <Element, Key>::
numberOfElementsWithKey (Key const& key) const
{ return IAKeyCollection <Element, Key>::numberOfElementsWithKey (key);
}

template <class Element, class Key>
inline INumber
IASortedMap <Element, Key>::
numberOfOccurrences (Element const& element) const
{ return IAEqualityCollection <Element>::numberOfOccurrences (element);
}

template <class Element, class Key>
inline INumber
IASortedMap <Element, Key>::
removeAllOccurrences (Element const& element)
{ return IAEqualityCollection <Element>::removeAllOccurrences (element);
}

template <class Element, class Key>
inline INumber
IASortedMap <Element, Key>::
removeAllElementsWithKey (Key const& key)
{ return IAKeyCollection <Element, Key>::removeAllElementsWithKey (key);
}

template <class Element, class Key>
inline IBoolean
IASortedMap <Element, Key>::
setToNextWithDifferentKey (ICursor& cursor) const
{ return
    IAKeyCollection <Element, Key>::setToNextWithDifferentKey (cursor);
}

// private members

template <class Element, class Key>
inline IASortedMap <Element, Key>::Implementation&
IASortedMap <Element, Key>::
ImplOf (IASortedMap <Element, Key> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
