/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IASR_H
#define _IASR_H

#include <iaeqksrt.h>
#include <iiasr.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key>
class IASortedRelation :
  public IAEqualityKeySortedCollection <Element, Key> {

  typedef  IAEqualityKeySortedCollection <Element, Key> Inherited;

  typedef  IASortedRelationImpl Implementation;

public:

           IASortedRelation
                            (INotifier&);

          ~IASortedRelation
                            ();

  void     addDifference    (IASortedRelation <Element, Key> const&,
                             IASortedRelation <Element, Key> const&); 

  void     addIntersection  (IASortedRelation <Element, Key> const&,
                             IASortedRelation <Element, Key> const&);

  void     addUnion         (IASortedRelation <Element, Key> const&,
                             IASortedRelation <Element, Key> const&);

  long     compare          (IASortedRelation <Element, Key> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
  void     differenceWith   (IASortedRelation <Element, Key> const&);

  void     intersectionWith (IASortedRelation <Element, Key> const&);

  void     unionWith        (IASortedRelation <Element, Key> const&);

  IBoolean operator==       (IASortedRelation
                              <Element, Key> const&) const;

  IBoolean operator!=       (IASortedRelation
                              <Element, Key> const&) const;

protected:

           IASortedRelation
                            ();

           IASortedRelation
                            (IASortedRelation <Element, Key> const&);

  INumber  numberOfOccurrences
                            (Element const&) const;

  INumber  removeAllOccurrences
                            (Element const&);

private:

  static
  Implementation&
           ImplOf           (IASortedRelation <Element, Key> const&);


};

#include <iasr.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
