/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IASortedSet
// ---

template <class Element>
inline
IASortedSet <Element>::
IASortedSet (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element>
inline
IASortedSet <Element>::
~IASortedSet ()
{
}

template <class Element>
inline void
IASortedSet <Element>::
addDifference (IASortedSet <Element> const& collection1,
               IASortedSet <Element> const& collection2)
{ ImplOf (*this).
    AddDifference (ImplOf (collection1), ImplOf (collection2));
}

template <class Element>
inline void
IASortedSet <Element>::
addIntersection (IASortedSet <Element> const& collection1,
                 IASortedSet <Element> const& collection2)
{ ImplOf (*this).
    AddIntersection (ImplOf (collection1), ImplOf (collection2));
}

template <class Element>
inline void
IASortedSet <Element>::
addUnion (IASortedSet <Element> const& collection1,
          IASortedSet <Element> const& collection2)
{ ImplOf (*this).
    AddUnion (ImplOf (collection1), ImplOf (collection2));
}

template <class Element>
inline long
IASortedSet <Element>::
compare (IASortedSet <Element> const& collection,
         long (*compFunc) (Element const&, Element const&)) const
{ return ImplOf (*this).
    Compare (ImplOf (collection), (ICompFunc)compFunc, 0);
}

template <class Element>
inline void
IASortedSet <Element>::
differenceWith (IASortedSet <Element> const& collection)
{ ImplOf (*this).Difference (ImplOf (collection));
}

template <class Element>
inline void
IASortedSet <Element>::
intersectionWith (IASortedSet <Element> const& collection)
{ ImplOf (*this).Intersection (ImplOf (collection));
}

template <class Element>
inline void
IASortedSet <Element>::
unionWith (IASortedSet <Element> const& collection)
{ ImplOf (*this).Union (ImplOf (collection));
}

template <class Element>
inline IBoolean
IASortedSet <Element>::
operator== (IASortedSet <Element> const& collection) const
{ return ImplOf (*this).operator== (ImplOf (collection));
}

template <class Element>
inline IBoolean
IASortedSet <Element>::
operator!= (IASortedSet <Element> const& collection) const
{ return ImplOf (*this).operator!= (ImplOf (collection));
}

// protected members

template <class Element>
inline
IASortedSet <Element>::
IASortedSet ()
{
}

template <class Element>
inline
IASortedSet <Element>::
IASortedSet (IASortedSet <Element> const& collection)
: Inherited (collection)
{
}

template <class Element>
inline INumber
IASortedSet <Element>::
numberOfOccurrences (Element const& element) const
{ return IAEqualityCollection <Element>::numberOfOccurrences (element);
}

template <class Element>
inline INumber
IASortedSet <Element>::
removeAllOccurrences (Element const& element)
{ return IAEqualityCollection <Element>::removeAllOccurrences (element);
}

// private members

template <class Element>
inline IASortedSet <Element>::Implementation&
IASortedSet <Element>::
ImplOf (IASortedSet <Element> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
