/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IAStack
// ---

template <class Element>
inline
IAStack <Element>::
IAStack (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element>
inline
IAStack <Element>::
~IAStack ()
{
}

template <class Element>
inline void
IAStack <Element>::
addAsLast (Element const& element)
{ ImplOf (*this).AddAsLast (&element);
}

template <class Element>
inline void
IAStack <Element>::
addAsLast (Element const& element, ICursor& cursor)
{ ImplOf (*this).AddAsLast (&element, CrsrImplOf (cursor));
}

template <class Element>
inline long
IAStack <Element>::
compare (IAStack <Element> const& collection,
         long (*compFunc) (Element const&, Element const&)) const
{ return ImplOf (*this).
    Compare (ImplOf (collection), (ICompFunc)compFunc, 0);
}

template <class Element>
inline void
IAStack <Element>::
pop ()
{ ImplOf (*this).RemoveLast ();
}

template <class Element>
inline void
IAStack <Element>::
pop (Element& element)
{ element = *(Element const*) ImplOf (*this).Last ();
  ImplOf (*this).RemoveLast ();
}

template <class Element>
inline void
IAStack <Element>::
push (Element const& element)
{ ImplOf (*this).AddAsLast (&element);
}

template <class Element>
inline void
IAStack <Element>::
push (Element const& element, ICursor& cursor)
{ ImplOf (*this).AddAsLast (&element, CrsrImplOf (cursor));
}

template <class Element>
inline void
IAStack <Element>::
removeLast ()
{ ImplOf (*this).RemoveLast ();
}

template <class Element>
inline Element const&
IAStack <Element>::
top () const
{ return *(Element const*) ImplOf (*this).Last ();
}

// protected members

template <class Element>
inline
IAStack <Element>::
IAStack ()
{
}

template <class Element>
inline
IAStack <Element>::
IAStack (IAStack <Element> const& collection)
: Inherited (collection)
{
}

// private members

template <class Element>
inline IAStack <Element>::Implementation&
IAStack <Element>::
ImplOf (IAStack <Element> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
