/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ------------------
// IElementTreeCursor
// ------------------

// public members

template <class Element>
inline Element const&
IElementTreeCursor <Element>::
element () const
{ return *(Element const*) ImplOf (*this).Element ();
}

// protected members

template <class Element>
inline
IElementTreeCursor <Element>::
IElementTreeCursor (Implementation* impl)
: ITreeCursor (impl)
{
}

// ------
// IATree
// ------

// public members

template <class Element>
inline
IATree <Element>::
~IATree ()
{
}

template <class Element>
inline void
IATree <Element>::
addAsChild (ITreeCursor const& cursor,
            IPosition position, Element const& element)
{ ImplOf (*this).AddAsChild (CrsrImplOf (cursor), position, &element);
}

template <class Element>
inline void
IATree <Element>::
addAsRoot (Element const& element)
{ ImplOf (*this).AddAsRoot (&element);
}

template <class Element>
inline IBoolean
IATree <Element>::
allElementsDo (IBoolean (*applFunc) (Element&, void*),
               ITreeIterationOrder order, void* addArg)
{ return ImplOf (*this).
    AllElementsDo ((IApplFunc)applFunc, order, addArg);
}

template <class Element>
inline IBoolean
IATree <Element>::
allElementsDo (IBoolean (*applFunc) (Element const&, void*),
               ITreeIterationOrder order, void* addArg) const
{ return ImplOf (*this).
    AllElementsDo ((IApplFunc)applFunc, order, addArg);
}

template <class Element>
inline IBoolean
IATree <Element>::
allElementsDo (IApplicator <Element>& applicator,
               ITreeIterationOrder order)
{ return ImplOf (*this).
    AllElementsDo ((IApplFunc)__applFunc, order, &applicator);
}

template <class Element>
inline IBoolean
IATree <Element>::
allElementsDo (IConstantApplicator <Element>& applicator,
               ITreeIterationOrder order) const
{ return ImplOf (*this).
    AllElementsDo ((IApplFunc)__applFunc, order, &applicator);
}

template <class Element>
inline IBoolean
IATree <Element>::
allSubtreeElementsDo
  (ITreeCursor const& cursor,
   IBoolean (*applFunc) (Element&, void*),
   ITreeIterationOrder order, void* addArg)
{ return ImplOf (*this).AllSubtreeElementsDo
    (CrsrImplOf (cursor), (IApplFunc)applFunc, order, addArg);
}

template <class Element>
inline IBoolean
IATree <Element>::
allSubtreeElementsDo
  (ITreeCursor const& cursor,
   IBoolean (*applFunc) (Element const&, void*),
   ITreeIterationOrder order, void* addArg) const
{ return ImplOf (*this).AllSubtreeElementsDo
    (CrsrImplOf (cursor), (IApplFunc)applFunc, order, addArg);
}

template <class Element>
inline IBoolean
IATree <Element>::
allSubtreeElementsDo (ITreeCursor const& cursor,
                      IApplicator <Element>& applicator,
                      ITreeIterationOrder order)
{ return ImplOf (*this).AllSubtreeElementsDo
    (CrsrImplOf (cursor), (IApplFunc)__applFunc, order, &applicator);
}

template <class Element>
inline IBoolean
IATree <Element>::
allSubtreeElementsDo (ITreeCursor const& cursor,
                      IConstantApplicator <Element>& applicator,
                      ITreeIterationOrder order) const
{ return ImplOf (*this).AllSubtreeElementsDo
    (CrsrImplOf (cursor), (IApplFunc)__applFunc, order, &applicator);
}

template <class Element>
inline IPosition
IATree <Element>::
childPositionAt (ITreeCursor const& cursor) const
{ return ImplOf (*this).ChildPositionAt (CrsrImplOf (cursor));
}

template <class Element>
inline Element&
IATree <Element>::
elementAt (ITreeCursor const& cursor)
{ return *(Element*) ImplOf (*this).ElementAt (CrsrImplOf (cursor));
}

template <class Element>
inline Element const&
IATree <Element>::
elementAt (ITreeCursor const& cursor) const
{ return *(Element const*) ImplOf (*this).
    ElementAt (CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IATree <Element>::
isConsistent () const
{ return ImplOf (*this).IsConsistent ();
}

template <class Element>
inline IBoolean
IATree <Element>::
isEmpty () const
{ return ImplOf (*this).IsEmpty ();
}

template <class Element>
inline IBoolean
IATree <Element>::
isLeaf (ITreeCursor const& cursor) const
{ return ImplOf (*this).IsLeaf (CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IATree <Element>::
isRoot (ITreeCursor const& cursor) const
{ return ImplOf (*this).IsRoot (CrsrImplOf (cursor));
}

template <class Element>
inline ITreeCursor*
IATree <Element>::
newCursor () const
{ return InterfaceFor (ImplOf (*this).CreateCursor ());
}

template <class Element>
inline INumber
IATree <Element>::
numberOfElements () const
{ return ImplOf (*this).NumberOfElements ();
}

template <class Element>
inline INumber
IATree <Element>::
numberOfLeaves () const
{ return ImplOf (*this).NumberOfLeaves ();
}

template <class Element>
inline INumber
IATree <Element>::
numberOfSubtreeElements (ITreeCursor const& cursor) const
{ return ImplOf (*this).NumberOfSubtreeElements (CrsrImplOf (cursor));
}

template <class Element>
inline INumber
IATree <Element>::
numberOfSubtreeLeaves (ITreeCursor const& cursor) const
{ return ImplOf (*this).NumberOfSubtreeLeaves (CrsrImplOf (cursor));
}

template <class Element>
inline IPosition
IATree <Element>::
position (ITreeCursor const& cursor) const
{ return ImplOf (*this).ChildPositionAt (CrsrImplOf (cursor));
}

template <class Element>
inline INumber
IATree <Element>::
removeAll ()
{ return ImplOf (*this).RemoveAll ();
}

template <class Element>
inline INumber
IATree <Element>::
removeSubtree (ITreeCursor& cursor)
{ return ImplOf (*this).RemoveSubtree (CrsrImplOf (cursor));
}

template <class Element>
inline void
IATree <Element>::
replaceAt (ITreeCursor const& cursor, Element const& element)
{ ImplOf (*this).ReplaceAt (CrsrImplOf (cursor), &element);
}

template <class Element>
inline IBoolean
IATree <Element>::
setToChild (IPosition position, ITreeCursor& cursor) const
{ return ImplOf (*this).SetToChild (position, CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IATree <Element>::
setToFirst (ITreeCursor& cursor, ITreeIterationOrder order) const
{ return ImplOf (*this).SetToFirst (CrsrImplOf (cursor), order);
}

template <class Element>
inline IBoolean
IATree <Element>::
setToFirstExistingChild (ITreeCursor& cursor) const
{ return ImplOf (*this).SetToFirstExistingChild (CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IATree <Element>::
setToLast (ITreeCursor& cursor, ITreeIterationOrder order) const
{ return ImplOf (*this).SetToLast (CrsrImplOf (cursor), order);
}

template <class Element>
inline IBoolean
IATree <Element>::
setToLastExistingChild (ITreeCursor& cursor) const
{ return ImplOf (*this).SetToLastExistingChild (CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IATree <Element>::
setToNext (ITreeCursor& cursor, ITreeIterationOrder order) const
{ return ImplOf (*this).SetToNext (CrsrImplOf (cursor), order);
}

template <class Element>
inline IBoolean
IATree <Element>::
setToNextExistingChild (ITreeCursor& cursor) const
{ return ImplOf (*this).SetToNextExistingChild (CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IATree <Element>::
setToParent (ITreeCursor& cursor) const
{ return ImplOf (*this).SetToParent (CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IATree <Element>::
setToPrevious (ITreeCursor& cursor, ITreeIterationOrder order) const
{ return ImplOf (*this).SetToPrevious (CrsrImplOf (cursor), order);
}

template <class Element>
inline IBoolean
IATree <Element>::
setToPreviousExistingChild (ITreeCursor& cursor) const
{ return ImplOf (*this).
    SetToPreviousExistingChild (CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IATree <Element>::
setToRoot (ITreeCursor& cursor) const
{ return ImplOf (*this).SetToRoot (CrsrImplOf (cursor));
}

// protected members

template <class Element>
inline
IATree <Element>::
IATree ()
: IATreeBase ()
{
}

template <class Element>
inline
IATree <Element>::
IATree (IATree <Element> const& tree)
: IATreeBase (tree)
{
}

template <class Element>
inline IATree <Element>::Implementation&
IATree <Element>::
ImplOf (IATree <Element> const& tree)
{ return *(Implementation*)tree.ivImpl;
}
