/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IBAG_H
#define _IBAG_H

#include <iabag.h>
#include <iicbag.h>
#include <iivbag.h>
#include <iibaglst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGBag;

template <class Element, class ElementOps>
class IGBagCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGBag
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGBagCursor
                            (IGBag
                              <
                               Element, ElementOps> const&);

  IGBagCursor <Element, ElementOps>&
           operator=        (IGBagCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGBagCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGBag :
  public IABag <Element> {
protected:

  typedef  IGBag <Element, ElementOps> Self;

  typedef  IBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICBagImpl
            <PureImplementation> Implementation;
#endif

#define IGBagTypedef(Element, ElementOps)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGBagTypedef (Element, ElementOps);

public:

  typedef  IGBagCursor
            <Element, ElementOps> Cursor;


           IGBag
                            (INumber = 100);

           IGBag
                            (IGBag
                              <
                               Element, ElementOps> const&);

  IGBag <Element, ElementOps>&
           operator=        (IGBag
                              <
                               Element, ElementOps> const&);


protected:

           IGBag
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGBag
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGBagCursor
            <Element, ElementOps>;



};

template <class Element>
class IBag :
  public IGBag
          <Element, ICOps <Element> > {

  typedef  IGBag
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IBag <Element> Self;

#define IBagTypedef(Element)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IBag
                            (INumber = 100);


protected:

           IBag
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGBag :
  public IGBag
          <Element, ElementOps > {

  typedef  IVGBag
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICBagImpl
            <IVBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGBagTypedef(Element, ElementOps)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGBagTypedef (Element, ElementOps);

public:

           IVGBag
                            (INumber = 100);


protected:

           IVGBag
                              (PureImplementation&);

private:


};

template <class Element>
class IVBag :
  public IVGBag
          <Element, ICOps <Element> > {

  typedef  IVGBag
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVBag <Element> Self;

#define IVBagTypedef(Element)\
  typedef  IVBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVBag
                            (INumber = 100);


protected:

           IVBag
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ibag.inl>

#pragma info (restore)
#pragma pack ()

#endif
