/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IBAGBST_H
#define _IBAGBST_H

#include <iabag.h>
#include <iicbag.h>
#include <iivbag.h>
#include <iibaglst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGBagAsBstTree;

template <class Element, class ElementOps>
class IGBagAsBstTreeCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGBagAsBstTree
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGBagAsBstTreeCursor
                            (IGBagAsBstTree
                              <
                               Element, ElementOps> const&);

  IGBagAsBstTreeCursor <Element, ElementOps>&
           operator=        (IGBagAsBstTreeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGBagAsBstTreeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGBagAsBstTree :
  public IABag <Element> {
protected:

  typedef  IGBagAsBstTree <Element, ElementOps> Self;

  typedef  IBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICBagImpl
            <PureImplementation> Implementation;
#endif

#define IGBagAsBstTreeTypedef(Element, ElementOps)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGBagAsBstTreeTypedef (Element, ElementOps);

public:

  typedef  IGBagAsBstTreeCursor
            <Element, ElementOps> Cursor;


           IGBagAsBstTree
                            (INumber = 100);

           IGBagAsBstTree
                            (IGBagAsBstTree
                              <
                               Element, ElementOps> const&);

  IGBagAsBstTree <Element, ElementOps>&
           operator=        (IGBagAsBstTree
                              <
                               Element, ElementOps> const&);


protected:

           IGBagAsBstTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGBagAsBstTree
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGBagAsBstTreeCursor
            <Element, ElementOps>;



};

template <class Element>
class IBagAsBstTree :
  public IGBagAsBstTree
          <Element, ICOps <Element> > {

  typedef  IGBagAsBstTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IBagAsBstTree <Element> Self;

#define IBagAsBstTreeTypedef(Element)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IBagAsBstTree
                            (INumber = 100);


protected:

           IBagAsBstTree
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGBagAsBstTree :
  public IGBagAsBstTree
          <Element, ElementOps > {

  typedef  IVGBagAsBstTree
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICBagImpl
            <IVBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGBagAsBstTreeTypedef(Element, ElementOps)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGBagAsBstTreeTypedef (Element, ElementOps);

public:

           IVGBagAsBstTree
                            (INumber = 100);


protected:

           IVGBagAsBstTree
                              (PureImplementation&);

private:


};

template <class Element>
class IVBagAsBstTree :
  public IVGBagAsBstTree
          <Element, ICOps <Element> > {

  typedef  IVGBagAsBstTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVBagAsBstTree <Element> Self;

#define IVBagAsBstTreeTypedef(Element)\
  typedef  IVBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVBagAsBstTree
                            (INumber = 100);


protected:

           IVBagAsBstTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ibagbst.inl>

#pragma info (restore)
#pragma pack ()

#endif
