/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGBagAsBstTreeCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGBagAsBstTreeCursor <Element, ElementOps>::
IGBagAsBstTreeCursor
  (IGBagAsBstTree
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGBagAsBstTreeCursor <Element, ElementOps>&
IGBagAsBstTreeCursor <Element, ElementOps>::
operator=
  (IGBagAsBstTreeCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGBagAsBstTreeCursor <Element, ElementOps>::
IGBagAsBstTreeCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGBagAsBstTree
// ---

// public members

template <class Element, class ElementOps>
inline
IGBagAsBstTree <Element, ElementOps>::
IGBagAsBstTree (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGBagAsBstTree <Element, ElementOps>::
IGBagAsBstTree
  (IGBagAsBstTree
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGBagAsBstTree <Element, ElementOps>&
IGBagAsBstTree <Element, ElementOps>::
operator= (IGBagAsBstTree
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGBagAsBstTree <Element, ElementOps>::
IGBagAsBstTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGBagAsBstTree
 <Element, ElementOps>::Implementation&
IGBagAsBstTree <Element, ElementOps>::
ImplOf (IGBagAsBstTree
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IBagAsBstTree
// ---

// public members

template <class Element>
inline
IBagAsBstTree <Element>::
IBagAsBstTree (INumber numberOfElements)
: IGBagAsBstTree
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IBagAsBstTree <Element>::
IBagAsBstTree (PureImplementation& impl)
: IGBagAsBstTree
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGBagAsBstTree
// ---

// public members

template <class Element, class ElementOps>
inline
IVGBagAsBstTree <Element, ElementOps>::
IVGBagAsBstTree (INumber numberOfElements)
: IGBagAsBstTree
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGBagAsBstTree <Element, ElementOps>::
IVGBagAsBstTree (PureImplementation& impl)
: IGBagAsBstTree
    <Element, ElementOps> (impl)
{
}

// ---
// IVBagAsBstTree
// ---

// public members

template <class Element>
inline
IVBagAsBstTree <Element>::
IVBagAsBstTree (INumber numberOfElements)
: IVGBagAsBstTree
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVBagAsBstTree <Element>::
IVBagAsBstTree (PureImplementation& impl)
: IVGBagAsBstTree
   <Element, ICOps <Element> > (impl)
{
}
