/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGBagAsDilTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGBagAsDilTableCursor <Element, ElementOps>::
IGBagAsDilTableCursor
  (IGBagAsDilTable
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGBagAsDilTableCursor <Element, ElementOps>&
IGBagAsDilTableCursor <Element, ElementOps>::
operator=
  (IGBagAsDilTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGBagAsDilTableCursor <Element, ElementOps>::
IGBagAsDilTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGBagAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGBagAsDilTable <Element, ElementOps>::
IGBagAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGBagAsDilTable <Element, ElementOps>::
IGBagAsDilTable
  (IGBagAsDilTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGBagAsDilTable <Element, ElementOps>&
IGBagAsDilTable <Element, ElementOps>::
operator= (IGBagAsDilTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGBagAsDilTable <Element, ElementOps>::
IGBagAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGBagAsDilTable
 <Element, ElementOps>::Implementation&
IGBagAsDilTable <Element, ElementOps>::
ImplOf (IGBagAsDilTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IBagAsDilTable
// ---

// public members

template <class Element>
inline
IBagAsDilTable <Element>::
IBagAsDilTable (INumber numberOfElements)
: IGBagAsDilTable
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IBagAsDilTable <Element>::
IBagAsDilTable (PureImplementation& impl)
: IGBagAsDilTable
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGBagAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGBagAsDilTable <Element, ElementOps>::
IVGBagAsDilTable (INumber numberOfElements)
: IGBagAsDilTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGBagAsDilTable <Element, ElementOps>::
IVGBagAsDilTable (PureImplementation& impl)
: IGBagAsDilTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVBagAsDilTable
// ---

// public members

template <class Element>
inline
IVBagAsDilTable <Element>::
IVBagAsDilTable (INumber numberOfElements)
: IVGBagAsDilTable
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVBagAsDilTable <Element>::
IVBagAsDilTable (PureImplementation& impl)
: IVGBagAsDilTable
   <Element, ICOps <Element> > (impl)
{
}
