/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGBagAsHshTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGBagAsHshTableCursor <Element, ElementOps>::
IGBagAsHshTableCursor
  (IGBagAsHshTable
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGBagAsHshTableCursor <Element, ElementOps>&
IGBagAsHshTableCursor <Element, ElementOps>::
operator=
  (IGBagAsHshTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGBagAsHshTableCursor <Element, ElementOps>::
IGBagAsHshTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGBagAsHshTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGBagAsHshTable <Element, ElementOps>::
IGBagAsHshTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGBagAsHshTable <Element, ElementOps>::
IGBagAsHshTable
  (IGBagAsHshTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGBagAsHshTable <Element, ElementOps>&
IGBagAsHshTable <Element, ElementOps>::
operator= (IGBagAsHshTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGBagAsHshTable <Element, ElementOps>::
IGBagAsHshTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGBagAsHshTable
 <Element, ElementOps>::Implementation&
IGBagAsHshTable <Element, ElementOps>::
ImplOf (IGBagAsHshTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IBagAsHshTable
// ---

// public members

template <class Element>
inline
IBagAsHshTable <Element>::
IBagAsHshTable (INumber numberOfElements)
: IGBagAsHshTable
   <Element, IEHOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IBagAsHshTable <Element>::
IBagAsHshTable (PureImplementation& impl)
: IGBagAsHshTable
   <Element, IEHOps <Element> > (impl)
{
}

// ---
// IVGBagAsHshTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGBagAsHshTable <Element, ElementOps>::
IVGBagAsHshTable (INumber numberOfElements)
: IGBagAsHshTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGBagAsHshTable <Element, ElementOps>::
IVGBagAsHshTable (PureImplementation& impl)
: IGBagAsHshTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVBagAsHshTable
// ---

// public members

template <class Element>
inline
IVBagAsHshTable <Element>::
IVBagAsHshTable (INumber numberOfElements)
: IVGBagAsHshTable
   <Element, IEHOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVBagAsHshTable <Element>::
IVBagAsHshTable (PureImplementation& impl)
: IVGBagAsHshTable
   <Element, IEHOps <Element> > (impl)
{
}
