/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// -------
// ICursor
// -------

// public members

inline void
ICursor::
copy (ICursor const& cursor)
{ ImplOf (*this).Copy (*cursor.ivImpl);
}

inline void
ICursor::
invalidate ()
{ ImplOf (*this).Invalidate ();
}

inline IBoolean
ICursor::
isValid () const
{ return ImplOf (*this).IsValid ();
}

inline IBoolean
ICursor::
setToFirst ()
{ return ImplOf (*this).SetToFirst ();
}

inline IBoolean
ICursor::
setToNext ()
{ return ImplOf (*this).SetToNext ();
}

inline void
ICursor::
operator= (ICursor const& cursor)
{ ImplOf (*this).Copy (ImplOf (cursor));
}

inline IBoolean
ICursor::
operator== (ICursor const& cursor) const
{ return ImplOf (*this).operator== (*cursor.ivImpl);
}

inline IBoolean
ICursor::
operator!= (ICursor const& cursor) const
{ return ImplOf (*this).operator!= (*cursor.ivImpl);
}

// protected members

inline
ICursor::
ICursor (Implementation* impl)
: ivImpl (impl)
{
}

inline
ICursor::
ICursor (ICursor const& cursor)
: ivImpl (ImplOf (cursor).Clone ())
{
}

inline ICursor::Implementation&
ICursor::
ImplOf (ICursor const& cursor)
{ return *cursor.ivImpl;
}

// ----------------
// IACollectionBase
// ----------------

// protected members

inline
IACollectionBase::
IACollectionBase ()
: IMetaCollection ()
{
}

inline
IACollectionBase::
IACollectionBase (IACollectionBase const& collection)
: IMetaCollection (collection)
{
}

inline
IACollectionBase::
~IACollectionBase ()
{
}

inline ICursorImpl&
IACollectionBase::
CrsrImplOf (ICursor& cursor)
{ return *cursor.ivImpl;
}

inline ICursorImpl const&
IACollectionBase::
CrsrImplOf (ICursor const& cursor)
{ return *cursor.ivImpl;
}
