#ifndef _BRUSH_MANAGER_
#define _BRUSH_MANAGER_

/*******************************************************************************
* FILE NAME: ibrshmgr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBrushElem IBrushManager                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
extern "C"
{
  #include <iwindefs.h>
}
#include <ikeyset.h>


/******************************************************************************
* class IBrushElem                                                             *
*******************************************************************************/
class IBrushElem
{
public:
/*------------------------------- Constructors -------------------------------*/
    IBrushElem(long lClr);
    IBrushElem();
    ~IBrushElem();

/*------------------------------ Public Members ------------------------------*/
    HBRUSH  getHandle() const { return hBrush; }
    long    getColor() const { return lColor; }

    long    useBrush();
    long    freeBrush();

    Boolean operator==(IBrushElem& );

    // Required to support IBrushElem's in IKeySet's
    friend const long&       key(const IBrushElem* k)
    { 
        return k->lColor; 
    }

/*--------------------------------- Private ----------------------------------*/
private:
    long     lColor;
    HBRUSH   hBrush;
    long     lUseCount;
};

/******************************************************************************
* class IBrushManager                                                          *
*******************************************************************************/
class IBrushManager {
public:
    typedef IKeySet<IBrushElem*, long > BrushList;

/*------------------------------ Public Members ------------------------------*/
    static HBRUSH  useBrush( long lClr );
    static void    freeBrush( HBRUSH );
    static long    brushCount( ) { return lBrushCount; }

protected:
/*------------------------------ Hidden Members ------------------------------*/
    static IBrushElem* IBrushManager::findBrush( long lClr );
    static IBrushElem* IBrushManager::findBrush( HBRUSH hBr );

/*--------------------------------- Private ----------------------------------*/
private:
    static BrushList brushList;
    static long lBrushCount;
};

#endif

