
#ifndef _IBUFFER_
#define _IBUFFER_
/*******************************************************************************
* FILE NAME: ibuffer.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBuffer                                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
extern "C" {
  #include <stddef.h>
  #include <stdio.h>
  #include <string.h>
  }

#include <ivbase.hpp>
#include <istrenum.hpp>

#pragma pack(4)



class IStringTest;

class IBuffer : public IVBase {
public:
/*------------------------------- Reallocation -------------------------------*/
IBuffer
 *newBuffer           ( const void* p1,
                        unsigned    len1,
                        const void* p2      = 0,
                        unsigned    len2    = 0,
                        const void* p3      = 0,
                        unsigned    len3    = 0,
                        char        padChar = 0 ) const;

static unsigned
  checkAddition       ( unsigned addend1,
                        unsigned addend2 ),
  checkMultiplication ( unsigned factor1,
                        unsigned factor2 ),
  overflow            ( );

static void
  setDefaultBuffer    ( IBuffer* newDefaultBuffer );

/*--------------------------------- Queries ----------------------------------*/
static IBuffer
 *defaultBuffer ( ),
 *fromContents  ( const char *pBuffer );

IBuffer
 *null          ( ) const;

unsigned
  useCount      ( ) const,
  length        ( ) const;

const char
 *contents      ( ) const;

char
 *contents      ( );

virtual IStringEnum::CharType
  charType      ( unsigned index ) const;

virtual char
 *next          ( const char *prev );

virtual const char
 *next          ( const char *prev ) const;

/*---------------------------- Reference Counting ----------------------------*/
void
  addRef    ( ),
  removeRef ( );

/*------------------------------- Comparisons --------------------------------*/
typedef enum {
  equal,
  greaterThan,
  lessThan
  } Comparison;

virtual Comparison
  compare ( const void* p,
            unsigned    len ) const;
/*---------------------------------- Subset ----------------------------------*/
virtual IBuffer
 *subString ( unsigned startPos,
              unsigned len,
              char     padCharacter ) const;

/*-----------------Internationalization functions----------------------*/
#ifdef IC_NLS
virtual IBuffer
 *subString ( unsigned startPos ) const;
#endif

/*------------------------------- Diagnostics --------------------------------*/
virtual IString
  asDebugInfo ( ) const;

/*--------------------------------- Testing ----------------------------------*/
virtual Boolean
  isAlphanumeric ( ) const,
  isAlphabetic   ( ) const,
  isASCII        ( ) const,
  isControl      ( ) const,
  isDigits       ( ) const,
  isGraphics     ( ) const,
  isHexDigits    ( ) const,
  isLowerCase    ( ) const,
  isPrintable    ( ) const,
  isPunctuation  ( ) const,
  isUpperCase    ( ) const,
  isWhiteSpace   ( ) const;

/*------------------------------- NLS Testing --------------------------------*/
virtual Boolean
  isMBCS       ( ) const,
  isDBCS       ( ) const,
  isSBCS       ( ) const,
  isValidMBCS  ( ) const,
  isValidDBCS  ( ) const,
  includesMBCS ( ) const,
  includesDBCS ( ) const,
  includesSBCS ( ) const;

/*--------------------------------- Searches ---------------------------------*/
virtual unsigned
  indexOf           ( const char*        pString,
                      unsigned           len,
                      unsigned           startPos = 1 ) const,
  indexOf           ( const IStringTest& aTest,
                      unsigned           startPos = 1 ) const,
  indexOfAnyBut     ( const char*        pString,
                      unsigned           len,
                      unsigned           startPos = 1 ) const,
  indexOfAnyBut     ( const IStringTest& aTest,
                      unsigned           startPos = 1 ) const,
  indexOfAnyOf      ( const char*        pString,
                      unsigned           len,
                      unsigned           startPos = 1 ) const,
  indexOfAnyOf      ( const IStringTest& aTest,
                      unsigned           startPos = 1 ) const,
  lastIndexOf       ( const char*        pString,
                      unsigned           len,
                      unsigned           startPos = 0 ) const,
  lastIndexOf       ( const IStringTest& aTest,
                      unsigned           startPos = 0 ) const,
  lastIndexOfAnyBut ( const char*        pString,
                      unsigned           len,
                      unsigned           startPos = 0 ) const,
  lastIndexOfAnyBut ( const IStringTest& aTest,
                      unsigned           startPos = 0 ) const,
  lastIndexOfAnyOf  ( const char*        pString,
                      unsigned           len,
                      unsigned           startPos = 0 ) const,
  lastIndexOfAnyOf  ( const IStringTest& aTest,
                      unsigned           startPos = 0 ) const;

/*--------------------------------- Editing ----------------------------------*/
virtual IBuffer
 *center       ( unsigned newLen,
                 char     padCharacter ),
 *change       ( const char* pSource,
                 unsigned    sourceLen,
                 const char* pTarget,
                 unsigned    targetLen,
                 unsigned    startPos,
                 unsigned    numChanges ),
 *copy         ( unsigned numCopies ),
 *insert       ( const char* pInsert,
                 unsigned    insertLen,
                 unsigned    pos,
                 char        padCharacter ),
 *leftJustify  ( unsigned newLen,
                 char     padCharacter ),
 *lowerCase    ( ),
 *overlayWith  ( const char* overlay,
                 unsigned    len,
                 unsigned    pos,
                 char        padCharacter ),
 *remove       ( unsigned startPos,
                 unsigned numChars ),
 *reverse      ( ),
 *rightJustify ( unsigned newLen,
                 char     padCharacter ),
 *strip        ( const char*            pChars,
                 unsigned               len,
                 IStringEnum::StripMode mode ),
 *strip        ( const IStringTest&     aTest,
                 IStringEnum::StripMode mode ),
 *translate    ( const char* pInputChars,
                 unsigned    inputLen,
                 const char* pOutputChars,
                 unsigned    outputLen,
                 char        padCharacter ),
 *upperCase    ( );

protected:

static Boolean isDBCSLead(char inByte);


/*-------------------------- Search Initialization ---------------------------*/
virtual unsigned
  startSearch          ( unsigned startPos,
                         unsigned searchLen ) const,
  startBackwardsSearch ( unsigned startPos,
                         unsigned searchLen ) const;

/*-------------------------------- Allocation --------------------------------*/
virtual IBuffer
 *allocate        ( unsigned bufLength ) const;

#ifdef __DEBUG_ALLOC__
void
 *operator new    ( size_t      t,
                    const char* filename,
                    size_t      linenum,
                    unsigned    bufLen );
void
  operator delete ( void*       p,
                    const char* filename,
                    size_t      linenum );
#else
void
 *operator new    ( size_t   t,
                    unsigned bufLen );
void
  operator delete ( void*    p );
#endif

/*-------------------------------- Initialize --------------------------------*/
static IBuffer
 *initialize ( );

/*---------------------------- Protected Queries -----------------------------*/
virtual const char
 *className ( ) const;

/*-------------------------- Protected Constructors --------------------------*/
  IBuffer ( unsigned newLen );
 ~IBuffer ( );

private:
/*--------------------------------- Private ----------------------------------*/
unsigned
  refs,
  len;
char
  data[1];
static IBuffer
 *nullBuffer;

static IBuffer
 *nullIBuffer;


/*-------------------------------- DBCS Table --------------------------------*/
static char
  dbcsTable[ 256 ];



};



#pragma pack()

  #include <ibuffer.inl>
  #include <ibuffern.inl>

#endif



