#ifndef _IBUTTON_
  #define _IBUTTON_
/*******************************************************************************
* FILE NAME: ibutton.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*    IButton                                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <itextctl.hpp>

class IColor;
class IButtonData;

#pragma pack(4)

class IButton : public ITextControl {
typedef ITextControl
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
virtual
 ~IButton ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IButton, IWindow, IControl);

static const Style
  IC_IMPORTU noPointerFocus;

/*------------------------------- Mouse Focus --------------------------------*/
virtual IButton
 &enableMouseClickFocus  ( Boolean enable = true ),
 &disableMouseClickFocus ( );
Boolean
  allowsMouseClickFocus  ( ) const;

/*-------------------------------- Highlight ---------------------------------*/
Boolean
  isHighlighted ( ) const;

virtual IButton
 &highlight     ( Boolean highlight = true ),
 &unhighlight   ( );

/*-------------------------------- Selection ---------------------------------*/
virtual IButton
 &click         ( );

/*---------------------------------- Color -----------------------------------*/
#ifndef IC_WIN_FLAGNOP
virtual IColor
  disabledForegroundColor ( ) const,
  hiliteForegroundColor   ( ) const,
  hiliteBackgroundColor   ( ) const;
#endif //!IC_WIN_FLAGNOP
virtual IColor
  foregroundColor         ( ) const,
  backgroundColor         ( ) const;

/*--------------------- Notification Event Descriptions ----------------------*/
static INotificationId const
  IC_IMPORTU buttonClickId;

/*-------------------------- Observer Notification ---------------------------*/
virtual IButton
  &enableNotification (Boolean enable = true);

/*----------------------------------- Text -----------------------------------*/
virtual IButton
 &setText       ( const char* text ),
 &setText       ( const IResourceId& text );

protected:

/*-------------------------- Protected Constructors --------------------------*/
  IButton ( );

private:
/*----------------------------- Hidden Functions -----------------------------*/
  IButton       ( const IButton& );
IButton
 &operator=     ( const IButton& );

/*--------------------------------- Private ----------------------------------*/
friend class IButtonHandler;
IButtonData
 *fButtonData;

};  // class IButton

INESTEDBITFLAGCLASSFUNCS(Style, IButton);

#pragma pack()

#endif  /* _IBUTTON_ */
