#ifndef _ICANVAS_
  #define _ICANVAS_
/*******************************************************************************
* FILE NAME: icanvas.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICanvas                                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <icontrol.hpp>
#include <ihandle.hpp>
#include <ipoint.hpp>
#include <irect.hpp>

class ICanvasData;
class ICanvasHandler;
class IColor;
class IFont;
class IWindowPosBuffer;

#pragma pack(4)

class ICanvas : public IControl {
typedef IControl
  Inherited;
public:
class Style;

/*------------------------------- Constructors -------------------------------*/
  ICanvas ( unsigned long     windowIdentifier,
            IWindow*          parent,
            IWindow*          owner,
            const IRectangle& initial = IRectangle(),
            const Style&      style = defaultStyle() );
virtual
 ~ICanvas ( );

/*---------------------------------- Style -----------------------------------*/
INESTEDBITFLAGCLASSDEF1(Style, ICanvas, IWindow);
static const Style
  IC_IMPORTU classDefaultStyle;
static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*---------------------------------- Colors ----------------------------------*/
virtual IColor
  backgroundColor ( ) const;

/*------------------------------ Font Functions ------------------------------*/
virtual IWindow
 &setFont       ( const IFont& font ),
 &resetFont     ( );

/*------------------------- Dialog Behavior Support --------------------------*/
virtual Boolean
  isTabStop               ( ) const;
IWindowHandle
  origDefaultButtonHandle ( ) const;
virtual IWindowHandle
  defaultPushButton       ( ) const,
  matchForMnemonic        ( unsigned short character ) const;

/*---------------------------------- Layout ----------------------------------*/
virtual ICanvas
 &setLayoutDistorted ( unsigned long layoutAttributesOn,
                       unsigned long layoutAttributesOff );

protected:
/*------------------------------- Constructors -------------------------------*/
  ICanvas ( );

/*------------------------------ Layout Support ------------------------------*/
virtual ICanvas
 &layout              ( );
ISize
  layoutSize          ( ) const;
ICanvas
 &setLayoutSize       ( const ISize& size );
virtual IWindowPosBuffer
  fixupChildren       ( );
Boolean
  areChildrenReversed ( ) const;
virtual ISize
  calcMinimumSize     ( ) const;

/*------------------------ Constructor Implementation ------------------------*/
ICanvas
 &initialize ( unsigned long     windowIdentifier,
               IWindow*          parent,
               IWindow*          owner,
               const IRectangle& initialRect,
               unsigned long     style,
               unsigned long     extendedStyle );

private:
/*----------------------------- Hidden Members -------------------------------*/
  ICanvas   ( const ICanvas& canvas );
ICanvas
 &operator= ( const ICanvas& canvas );

/*--------------------------------- Private ----------------------------------*/
friend class ICanvasHandler;
static Style
  currentDefaultStyle;
ISize
  sizClLayout;
IWindowHandle
  hwndClDefaultButton;
Boolean
  bClChildrenReversed,
  bClDefaultHandlerAdded;
IFont
 *fFont;
ICanvasData
 *fCanvasData;
};  // ICanvas

INESTEDBITFLAGCLASSFUNCS(Style, ICanvas);

#pragma pack()

  #include <icanvas.inl>

#endif /* _ICANVAS_ */
