#ifndef _ICCONST_
#define _ICCONST_

/*******************************************************************************
* FILE NAME: icconst.h                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   User Interface resource identifier macro constants.                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _ICCONSTA_
   #include <icconsta.h>
#endif

#define IC_ASSERTPARM                          1
#define IC_MEMBER_ACCESS_ERROR                 2
#define IC_UNEXPECTED_ERROR                    3
#define IC_HEAP_EXHAUSTED                      4
#define IC_WINDOW_DELETE_FROM_CALLBACK         5

#define IC_THIS_PLATFORM_NOT_SUPPORTED        10

#define IC_RELEASEPSFAIL                      30
#define IC_INVALIDCHARCODE                    31
#define IC_INVALIDSCANCODE                    32
#define IC_INVALIDVIRTUALKEY                  33
#define IC_PRESPARAMNOTFOUND                  34
#define IC_INVALIDCOLORINDEX                  35
#define IC_INVALIDEVENT                       36
#define IC_DBCSCHARASSERT                     37
#define IC_DBCSSCANCODEASSERT                 38
#define IC_INVALIDENUMVALUE                   39
#define IC_NOMARKEDTEXT                       40
#define IC_CLIPBOARDEMPTY                     41
#define IC_HANDLERNOTFOUND                    42
#define IC_INVALIDSTYLE                       43
#define IC_INVALIDSIZE                        44
#define IC_FRAME_EXTENSION_NOT_FOUND          45
#define IC_INVALID_THREAD_ID                  46
#define IC_THREAD_STARTED                     47
#define IC_SUSPEND_PM_THREAD                  48
#define IC_SEMAPHORES_EXHAUSTED               49
#define IC_VIEWPORT_INVALID_SCROLL            50
#define IC_CNROBJ_INVALID_OBJECTCOPY          53
#define IC_CNROBJ_INVALID_CREATE              54
#define IC_MULTICELLCANVAS_CELL_OVERLAP       55
#define IC_DISPATCHTO_INVALID_HANDLER         56
#define IC_INVALIDSIZE_LIMIT                  57
#define IC_NULL_IREFERENCE                    58
#define IC_XMCREATE_FAILURE                   59
#define IC_XMSTRING_INIT_FAILURE              60
#define IC_INVALIDHANDLE                      61
#define IC_NO_WINDOW_WITHID                   62
#define IC_PARENT_IS_NOT_IWINDOW              63
#define IC_CONTROL_NOT_FOUND                  64
#define IC_WRONG_CONTROL_TYPE                 65
#define IC_THREAD_VARIABLE_LIMIT_EXCEEDED     66
#define IC_VECTOR_FONT_ONLY_FUNCTION          67
#define IC_CNRALLOCATOR_LIMIT_EXCEEDED        68
#define IC_CNRALLOCATOR_INVALIDNUMVALUE       69
#define IC_MUST_HAVE_TITLE_TEXT               70
#define IC_THREAD_NOT_STARTED_WIN32S          71
#define IC_CLASS_NOT_SUPPORTED_ON_WIN32S      72
#define IC_MEMBER_FUN_NOT_SUPPORTED_ON_WIN32S 73

#define IC_HELPERRORMSGBOX_TITLE              80
#define IC_HMERR_LOAD_DLL                     81
#define IC_HMERR_NO_FRAME_WND_IN_CHAIN        82
#define IC_HMERR_INVALID_ASSOC_APP_WND        83
#define IC_HMERR_INVALID_ASSOC_HELP_INST      84
#define IC_HMERR_INVALID_QUERY_APP_WND        85
#define IC_HMERR_HELPTABLE_UNDEFINE           86
#define IC_HMERR_HELP_INSTANCE_UNDEFINE       87
#define IC_HMERR_HELPITEM_NOT_FOUND           88
#define IC_HMERR_INDEX_NOT_FOUND              89
#define IC_HMERR_CONTENT_NOT_FOUND            90
#define IC_HMERR_OPEN_LIB_FILE                91
#define IC_HMERR_READ_LIB_FILE                92
#define IC_HMERR_CLOSE_LIB_FILE               93
#define IC_HMERR_INVALID_LIB_FILE             94
#define IC_HMERR_NO_MEMORY                    95
#define IC_HMERR_FREE_MEMORY                  96
#define IC_HMERR_PANEL_NOT_FOUND              97
#define IC_HMERR_DATABASE_NOT_OPEN            98
#define IC_HMERR_UNKNOWN                      99
#define IC_THREAD_NOT_PROCESSING_MSGS        100
#define IC_FRAME_EXTENSION_IN_USE            101
#define IC_HMERR_FONT_ERROR                  102
#define IC_FONT_ACCESS_ERROR                 103
#define IC_NOSTATUSTEXTLINE                  104

#define IC_DDE_SERVER_IN_CONVERSATION        121
#define IC_DDE_CLIENT_NOT_IN_CONVERSATION    122
#define IC_DDE_SERVER_NOT_IN_CONVERSATION    123
#define IC_DDE_WINDDEINITIATE                124
#define IC_DDE_WINDDEPOSTMESSAGE_USER        125
#define IC_DDE_HOTLINK_ACTIVE                128
#define IC_DDE_HOTLINK_PENDING               129
#define IC_DDE_NO_HOTLINK                    130
#define IC_DDE_NO_HOTLINKS                   131
#define IC_DDE_NO_HOTLINKS_ITEM              132
#define IC_DDE_END_HOTLINK_PENDING           133
#define IC_DDE_END_HOTLINKS_ITEM_PENDING     134
#define IC_DDE_END_HOTLINKS_PENDING          135
#define IC_DDE_SYNCHRONIZATION               136
#define IC_SLDR_RECT_TOO_SMALL               137
#define IC_INVALID_RANGE_OPERATION           138
#define IC_INVALID_TEXT_OPERATION            139
#define IC_SET_SPIN_ARRAY_FAIL               140
#define IC_SETMENUITEM_FAIL                  141
#define IC_INVALID_MENUITEM                  142
#define IC_NO_SYSTEMMENU                     143
#define IC_NO_FRAME_MENUBAR                  144
#define IC_NO_BITMAP_HANDLE                  145
#define IC_VALUE_OUT_OF_RANGE                146
#define IC_NO_MENU_SELECTED                  147
#define IC_ADD_SUBMENU_FAIL                  148
#define IC_NO_TITLEBAR                       149
#define IC_SLDR_SET_CTLDATA                  150
#define IC_SLDR_GET_CTLDATA                  151
#define IC_NO_SUBMENU                        152
#define IC_NO_HELP_COVERPAGE                 153
#define IC_INVALID_INDEX                     154
#define IC_UNKNOWN_RENDERING_FORMAT          155
#define IC_UNKNOWN_RENDERING_MECHANISM       156
#define IC_RFPROCESS_FOR_SAME_PROCESS        157
#define IC_RENDER_AT_SOURCE_FAILED           158
#define IC_DRAGTRANSFER_INVALID              159
#define IC_NO_SOURCE_OBJECT_SUPPLIED         160
#define IC_INDEX_OUT_OF_RANGE                161
#define IC_TARGET_ITEM_PROVIDER_FAILED       162
#define IC_DRAGITEM_INVALID                  163
#define IC_CLIPBOARD_LOCKED                  164
#define IC_CLIPBOARD_TRUNCATE                165
#define IC_INVALID_FRAME_SHELL               166
#define IC_SLDR_INVALID_TICK_COUNT           167
#define IC_SLDR_INVALID_TICK_NUMBER          168
#define IC_SLDR_INVALID_PIXEL                169


#define IC_APPLICATION_INITIALIZE            170
#define IC_MODIFIER_MISMATCH                 171
#define IC_INVALID_TIMER_ID                  172
#define IC_TIMER_STARTED                     173
#define IC_TIMER_ID_UNAVAILABLE              174

#define IC_INVALID_CLASS                     180
#define IC_INVALID_VISIBLECOUNT              181
#define IC_NAME_NOT_FOUND                    182
#define IC_TEXT_NOT_FOUND                    183
#define IC_EMPTY_LIST                        184
#define IC_GUI_ERROR                         185
#define IC_SYSTEM_ERROR                      186
#define IC_INVALID_SETTEXT                   187
#define IC_NUMSPIN_WRAP_INVALID              190
#define IC_TXTSPIN_WRAP_INVALID              191
#define IC_SPINTO_TEXT_INVALID               192
#define IC_NO_SELECTION                      193 /* IListBox and IComboBox */
#define IC_SINGLE_SELECT_LIST                194 /* IListBox and IComboBox */

#define IC_LABEL_ABORT                       201
#define IC_LABEL_RETRY                       202
#define IC_LABEL_IGNORE                      203
#define IC_LABEL_ENTER                       204
#define IC_LABEL_HELP                        205
#define IC_LABEL_APPLY                       206
#define IC_LABEL_RESET                       207
#define IC_LABEL_OK                          208
#define IC_LABEL_CANCEL                      209
#define IC_INVALID_PICTURE_ID                210
#define IC_INVALID_PICTURE_QUOTE             211
#define IC_INVALID_PICTURE_RANGE             212
#define IC_FFBMP                             213
#define IC_REWBMP                            214
#define IC_RECBMP                            215
#define IC_PAUSEBMP                          216
#define IC_TRKRBMP                           217
#define IC_TRKABMP                           218
#define IC_STOPBMP                           219
#define IC_STEPFBMP                          220
#define IC_STEPBBMP                          221
#define IC_EJECTBMP                          222
#define IC_SCANFBMP1                         223
#define IC_SCANFBMP2                         224
#define IC_SCANFBMP3                         225
#define IC_SCANFBMP4                         226
#define IC_SCANFBMP5                         227
#define IC_SCANFBMP6                         228
#define IC_SCANBBMP1                         229
#define IC_SCANBBMP2                         230
#define IC_SCANBBMP3                         231
#define IC_SCANBBMP4                         232
#define IC_SCANBBMP5                         233
#define IC_SCANBBMP6                         234
#define IC_PLAYBMP1                          235
#define IC_PLAYBMP2                          236
#define IC_PLAYBMP3                          237
#define IC_PLAYBMP4                          238
#define IC_PLAYBMP5                          239
#define IC_MUTEBMP                           240
#define IC_VOLUPBMP                          241
#define IC_VOLDNBMP                          242

#define IC_LABEL_FILTER                      249 /* Motif IFileDialog */
#define IC_MAPPOINT_FAILED                   250
#define IC_LABEL_YES                         251
#define IC_LABEL_NO                          252
#define IC_LABEL_FONTDLG_SEL                 253
#define IC_LABEL_FONTDLG_POINTSEL            254
#define IC_NOCLIPBOARDDATA                   255
#define IC_REGISTERCLIPBOARDFORMATFAILED     256
#define IC_CLIPBOARDFORMATNOTFOUND           257

// The following identifiers are used for exception handling in the GBM
// image handling code.

#define IC_GBM_UNKNOWN_ERROR                 258
#define IC_GBM_OPEN_FAILED                   259
#define IC_GBM_CREATE_FAILED                 260
#define IC_GBM_NO_SUPPORT                    261
#define IC_GBM_HDC_FAILED                    262
#define IC_GBM_HPS_FAILED                    263
#define IC_GBM_METAFILE_FAILED               264
#define IC_GBM_BITMAP_FAILED                 265
#define IC_GBM_NEED_CLIPPED                  266
#define IC_GBM_NOT_SUPPORTED                 267
#define IC_GBM_BAD_OPTION                    268
#define IC_GBM_NOT_FOUND                     269
#define IC_GBM_BAD_MAGIC                     270
#define IC_GBM_BAD_SIZE                      271
#define IC_GBM_READ_FAILED                   272
#define IC_GBM_WRITE_FAILED                  273
#define IC_GBM_BMP_PLANES                    274
#define IC_GBM_BMP_BITCOUNT                  275
#define IC_GBM_BMP_CBFIX                     276
#define IC_GBM_BMP_COMP                      277
#define IC_GBM_BMP_OFFSET                    278
#define IC_GBM_GIF_BPP                       279
#define IC_GBM_GIF_TERM                      280
#define IC_GBM_GIF_CODE_SIZE                 281
#define IC_GBM_GIF_CORRUPT                   282
#define IC_GBM_IAX_SIZE                      283
#define IC_GBM_KPS_OPEN                      284
#define IC_GBM_KPS_CREATE                    285
#define IC_GBM_LBM_FORM                      286
#define IC_GBM_LBM_ILBM                      287
#define IC_GBM_LBM_BMHD_2                    288
#define IC_GBM_LBM_BMHD_0                    289
#define IC_GBM_LBM_BMHD_SIZE                 290
#define IC_GBM_LBM_BPP                       291
#define IC_GBM_LBM_CMAP_SIZE                 292
#define IC_GBM_LBM_COMP                      293
#define IC_GBM_LBM_CAMG_SIZE                 294
#define IC_GBM_LBM_SHAM_VER                  295
#define IC_GBM_PCX_BAD_VERSION               296
#define IC_GBM_PCX_BAD_ENCMODE               297
#define IC_GBM_PCX_BAD_BITS                  298
#define IC_GBM_PCX_BAD_TRAILER               299
#define IC_GBM_PGM_BAD_M                     300
#define IC_GBM_PSEG_NOT_5A                   301
#define IC_GBM_PSEG_BAD_RECORD               302
#define IC_GBM_PSEG_SIZE                     303
#define IC_GBM_PSEG_INV_WIDTH                304
#define IC_GBM_PSEG_INV_DEFCEL               305
#define IC_GBM_PSEG_INV_CEL                  306
#define IC_GBM_PSEG_INV_CELPOS               307
#define IC_GBM_PSEG_UNEX_REC                 308
#define IC_GBM_SPR_FIRST                     309
#define IC_GBM_SPR_MODE                      310
#define IC_GBM_SPR_OFFSET                    311
#define IC_GBM_SPR_PAL8                      312
#define IC_GBM_TGA_BAD_BPP                   313
#define IC_GBM_TGA_BAD_TYPE                  314
#define IC_GBM_TGA_BAD_PAL                   315
#define IC_GBM_TIF_VERSION                   316
#define IC_GBM_TIF_N_TAGS                    317
#define IC_GBM_TIF_TAG_TYPE                  318
#define IC_GBM_TIF_HEADER                    319
#define IC_GBM_TIF_MISSING_TAG               320
#define IC_GBM_TIF_SPP_BIT                   321
#define IC_GBM_TIF_BPS_BIT                   322
#define IC_GBM_TIF_SPP_RGB                   323
#define IC_GBM_TIF_BPS_RGB                   324
#define IC_GBM_TIF_SPP_PAL                   325
#define IC_GBM_TIF_BPS_PAL                   326
#define IC_GBM_TIF_SPP_CMYK                  327
#define IC_GBM_TIF_BPS_CMYK                  328
#define IC_GBM_TIF_COMP_1D_MH                329
#define IC_GBM_TIF_COMP_T4                   330
#define IC_GBM_TIF_COMP_T6                   331
#define IC_GBM_TIF_COMP                      332
#define IC_GBM_TIF_COLORMAP                  333
#define IC_GBM_TIF_CORRUPT                   334
#define IC_GBM_TIF_PREDICTOR                 335
#define IC_GBM_TIF_PHOTO_TRANS               336
#define IC_GBM_TIF_PHOTO_Y_Cb_Cr             337
#define IC_GBM_TIF_PHOTO                     338
#define IC_GBM_TIF_FILLORDER                 339
#define IC_GBM_TIF_PLANARCONFIG_1            340
#define IC_GBM_TIF_PLANARCONFIG_12           341
#define IC_GBM_TIF_INKSET                    342
#define IC_GBM_TIF_ORIENT                    343
#define IC_GBM_TIF_INDEX                     344
#define IC_GBM_VID_BAD_W                     345
#define IC_GBM_XBM_EXP_ID                    346
#define IC_GBM_XBM_UNEXP_EOF                 347
#define IC_GBM_XBM_EXP_CHAR                  348
#define IC_GBM_XBM_EXP_LSQR                  349
#define IC_GBM_XBM_EXP_RSQR                  350
#define IC_GBM_XBM_EXP_EQUALS                351
#define IC_GBM_XBM_EXP_LCUR                  352
#define IC_GBM_XBM_EXP_RCUR                  353
#define IC_GBM_XBM_EXP_COMMA                 354
#define IC_GBM_XBM_EXP_NUMBER                355
#define IC_GBM_XBM_EXP_SEMI                  356

#define IC_TOOLBAR_POINTER_TOP               357
#define IC_TOOLBAR_POINTER_BOTTOM            358
#define IC_TOOLBAR_POINTER_LEFT              359
#define IC_TOOLBAR_POINTER_RIGHT             360
#define IC_TOOLBAR_POINTER_TOP_2             361
#define IC_TOOLBAR_POINTER_BOTTOM_2          362
#define IC_TOOLBAR_POINTER_LEFT_2            363
#define IC_TOOLBAR_POINTER_RIGHT_2           364

// Note: 370 through 399 reserved for collections.
#define IC_CHILD_ALREADY_EXISTS              370
#define IC_COLLECTION_IS_EMPTY               371
#define IC_CURSOR_NOT_CONTAINED              372
#define IC_CURSOR_NOT_FOR_GIVEN              373
#define IC_CURSOR_NOT_FOR_THIS               374
#define IC_IDENTICAL_COLLECTION              375
#define IC_INVALID_CURSOR                    376
#define IC_INVALID_POSITION                  377
#define IC_INVALID_REPLACEMENT               378
#define IC_KEY_ALREADY_EXISTS                379
#define IC_KEY_NOT_CONTAINED                 380
#define IC_NOT_BOUNDED                       381
#define IC_OUT_OF_COLLECTION_MEMORY          382
#define IC_ROOT_ALREADY_EXISTS               383
#define IC_CYCLIC_CHILD_ATTACHMENT           384

// Note: 400 through 430 in icconsta.h and used by streams.

#define IC_CDF_UNTITLED_NAME                 450
#define IC_CDF_INSERT_FAILED                 451
#define IC_CDF_OPEN_FAILED                   452
#define IC_CDF_DISCARD                       453
#define IC_CDF_SAVE                          454
#define IC_CDF_SAVE_FAILED                   455
#define IC_CDF_EMBEDDED_TITLE                456
#define IC_CDF_ACTIVATE_FAILED               457
#define IC_CDF_IN_PLACE_FRAME_NAME           458

#define IC_DEFAULT_FRAME_ID                 1000
#define IC_FRAME_MENU_ID                  0x8005
#define IC_FRAME_CLIENT_ID                0x8008

// The following are standard identifiers for push buttons.
#define IC_ID_OK                               1
#define IC_ID_CANCEL                           2

// The following identifiers are defined for IFileDialog and IFontDialog
// portability.
#define IC_FILE_DIALOG                      1536
#define IC_FILE_DIALOG_MULTSELECT           1537
#define IC_ID_FILEOK                    IC_ID_OK
#define IC_ID_FILECANCEL            IC_ID_CANCEL
#define IC_ID_FILEAPPLY                   0x0402
#define IC_FONT_DIALOG                      1542
#define IC_ID_FONTOK                    IC_ID_OK
#define IC_ID_FONTCANCEL            IC_ID_CANCEL
#define IC_ID_FONTAPPLY                   0x0402

// The following identifiers represent common system commands.
#define IC_ID_CLOSE                       0xF060
#define IC_ID_MOVE                        0xF010
#define IC_ID_SIZE                        0xF000
#define IC_ID_MINIMIZE                    0xF020
#define IC_ID_MAXIMIZE                    0xF030
#define IC_ID_SYSHIDE                     0xF020
#define IC_ID_RESTORE                     0xF120
#define IC_ID_WINDOWLIST                  0xF130


#ifndef IC_ID_BASE
  #define IC_ID_BASE                  ( 0x7000 )
#endif
// The following identifiers are defined and may be used when constructing
// IToolBarButtons for standard operations.
#define IC_ID_OPEN         (IC_ID_BASE + 0x0001)
#define IC_ID_SAVE         (IC_ID_BASE + 0x0002)
#define IC_ID_PRINT        (IC_ID_BASE + 0x0003)
#define IC_ID_LOCATE       (IC_ID_BASE + 0x0004)
#define IC_ID_CUT          (IC_ID_BASE + 0x0005)
#define IC_ID_COPY         (IC_ID_BASE + 0x0006)
#define IC_ID_PASTE        (IC_ID_BASE + 0x0007)
#define IC_ID_HELP         (IC_ID_BASE + 0x0008)
#define IC_ID_BOLD         (IC_ID_BASE + 0x0009)
#define IC_ID_ITALIC       (IC_ID_BASE + 0x000A)
#define IC_ID_UNDERSCORE   (IC_ID_BASE + 0x000B)
#define IC_ID_SETTINGS     (IC_ID_BASE + 0x000C)
#define IC_ID_COPYTO       (IC_ID_BASE + 0x000D)

// The following identifiers are defined and used by the class libary
// when constructing special IToolBarButtons.
#define IC_ID_DEFAULT      (IC_ID_BASE + 0x0101)
#define IC_ID_OWNERMOVE    (IC_ID_BASE + 0x0102)
#define IC_ID_NOOWNERMOVE  (IC_ID_BASE + 0x0103)
#define IC_ID_SHOWHIDE     (IC_ID_BASE + 0x0105)
#define IC_ID_SHOW         (IC_ID_BASE + 0x0106)
#define IC_ID_HIDE         (IC_ID_BASE + 0x0107)

#define IC_SMALLSYSTEMMENU (IC_ID_BASE + 0x0111)
#define IC_FADEICON        (IC_ID_BASE + 0x0112)
#define IC_FF              (IC_ID_BASE + 0x0113)
#define IC_REWIND          (IC_ID_BASE + 0x0114)
#define IC_RECORD          (IC_ID_BASE + 0x0115)
#define IC_PAUSE           (IC_ID_BASE + 0x0116)
#define IC_TRKR            (IC_ID_BASE + 0x0117)
#define IC_TRKA            (IC_ID_BASE + 0x0118)
#define IC_STOP            (IC_ID_BASE + 0x0119)
#define IC_STEPF           (IC_ID_BASE + 0x011A)
#define IC_STEPB           (IC_ID_BASE + 0x011B)
#define IC_EJECT           (IC_ID_BASE + 0x011C)
#define IC_SCANF1          (IC_ID_BASE + 0x011D)
#define IC_SCANF2          (IC_ID_BASE + 0x011E)
#define IC_SCANF3          (IC_ID_BASE + 0x011F)
#define IC_SCANF4          (IC_ID_BASE + 0x0120)
#define IC_SCANF5          (IC_ID_BASE + 0x0121)
#define IC_SCANF6          (IC_ID_BASE + 0x0122)
#define IC_SCANB1          (IC_ID_BASE + 0x0123)
#define IC_SCANB2          (IC_ID_BASE + 0x0124)
#define IC_SCANB3          (IC_ID_BASE + 0x0125)
#define IC_SCANB4          (IC_ID_BASE + 0x0126)
#define IC_SCANB5          (IC_ID_BASE + 0x0127)
#define IC_SCANB6          (IC_ID_BASE + 0x0128)
#define IC_PLAY1           (IC_ID_BASE + 0x0129)
#define IC_PLAY2           (IC_ID_BASE + 0x012A)
#define IC_PLAY3           (IC_ID_BASE + 0x012B)
#define IC_PLAY4           (IC_ID_BASE + 0x012C)
#define IC_PLAY5           (IC_ID_BASE + 0x012D)
#define IC_MUTE            (IC_ID_BASE + 0x012E)
#define IC_VOLUP           (IC_ID_BASE + 0x012F)
#define IC_VOLDN           (IC_ID_BASE + 0x0130)
#define IC_COLLAPSEICON    (IC_ID_BASE + 0x0131)
#define IC_EXPANDICON      (IC_ID_BASE + 0x0132)
#define IC_INUSEICON       (IC_ID_BASE + 0x0133)
#define IC_SMALLINUSEICON  (IC_ID_BASE + 0x0134)
#define IC_BMPHALFTONE     (IC_ID_BASE + 0x0135)
#define IC_BMPDENSE1       (IC_ID_BASE + 0x0136)
#define IC_BMPDENSE2       (IC_ID_BASE + 0x0137)
#define IC_BMPDENSE3       (IC_ID_BASE + 0x0138)
#define IC_BMPDENSE4       (IC_ID_BASE + 0x0139)
#define IC_BMPDENSE5       (IC_ID_BASE + 0x013A)
#define IC_BMPDENSE6       (IC_ID_BASE + 0x013B)
#define IC_BMPDENSE7       (IC_ID_BASE + 0x013C)
#define IC_BMPDENSE8       (IC_ID_BASE + 0x013D)
#define IC_BMPFDIAG2       (IC_ID_BASE + 0x013E)
#define IC_BMPBDIAG2       (IC_ID_BASE + 0x013F)

// The following are cursors used during drag and drop.
#define IC_DM_NO           (IC_ID_BASE + 0x0141)
#define IC_DM_COPY         (IC_ID_BASE + 0x0142)
#define IC_DM_SHORTCUT     (IC_ID_BASE + 0x0143)

// The following are menu items used during non-default drag and drop.
#define IC_DM_MI_MOVE      (IC_ID_BASE + 0x0144)
#define IC_DM_MI_COPY      (IC_ID_BASE + 0x0145)
#define IC_DM_MI_SHORTCUT  (IC_ID_BASE + 0x0146)
#define IC_DM_MI_CANCEL    (IC_ID_BASE + 0x0147)

// The following are IDs of child windows created by IViewPort.
#define IC_VIEWPORT_VERTSCROLLBAR  ( IC_ID_BASE + 201 )
#define IC_VIEWPORT_HORZSCROLLBAR  ( IC_ID_BASE + 202 )
#define IC_VIEWPORT_VIEWRECTANGLE  ( IC_ID_BASE + 203 )

// The following are used by Compound Document Framework.
#define IC_ID_FILE         (IC_ID_BASE + 0x0301)
#define IC_ID_EDIT         (IC_ID_BASE + 0x0302)
#define IC_ID_VIEW         (IC_ID_BASE + 0x0303)
#define IC_ID_INSERT       (IC_ID_BASE + 0x0304)
#define IC_ID_NEW          (IC_ID_BASE + 0x0305)
#define IC_ID_SAVE_AS      (IC_ID_BASE + 0x0306)
#define IC_ID_EXIT         (IC_ID_BASE + 0x0307)
#define IC_ID_UNDO         (IC_ID_BASE + 0x0308)
#define IC_ID_TOOLBAR      (IC_ID_BASE + 0x0309)
#define IC_ID_ABOUT        (IC_ID_BASE + 0x0310)
#define IC_ID_UPDATE       (IC_ID_BASE + 0x0311)
#define IC_ID_SAVE_COPY_AS (IC_ID_BASE + 0x0312)
#define IC_ID_PASTESPECIAL (IC_ID_BASE + 0x0313)
#define IC_ID_PASTELINK    (IC_ID_BASE + 0x0314)
#define IC_ID_VERB0        (IC_ID_BASE + 0x0315)
#define IC_ID_VERB1        (IC_ID_BASE + 0x0316)
#define IC_ID_VERB2        (IC_ID_BASE + 0x0317)
#define IC_ID_VERB3        (IC_ID_BASE + 0x0318)
#define IC_ID_VERB4        (IC_ID_BASE + 0x0319)
#define IC_ID_VERB5        (IC_ID_BASE + 0x0320)
#define IC_ID_VERB6        (IC_ID_BASE + 0x0321)
#define IC_ID_VERB7        (IC_ID_BASE + 0x0322)
#define IC_ID_VERB8        (IC_ID_BASE + 0x0323)
#define IC_ID_VERB9        (IC_ID_BASE + 0x0324)
#define IC_ID_VERB10       (IC_ID_BASE + 0x0325)
#define IC_ID_VERB11       (IC_ID_BASE + 0x0326)
#define IC_ID_VERB12       (IC_ID_BASE + 0x0327)
#define IC_ID_VERB13       (IC_ID_BASE + 0x0328)
#define IC_ID_VERB14       (IC_ID_BASE + 0x0329)
#define IC_ID_VERB15       (IC_ID_BASE + 0x0330)
#define IC_ID_VERB16       (IC_ID_BASE + 0x0331)
#define IC_ID_VERB17       (IC_ID_BASE + 0x0332)
#define IC_ID_VERB18       (IC_ID_BASE + 0x0333)
#define IC_ID_VERB19       (IC_ID_BASE + 0x0334)
#define IC_ID_EDITLINKS    (IC_ID_BASE + 0x0335)
#define IC_ID_CONVERT      (IC_ID_BASE + 0x0336)
#define IC_ID_SELECTALL    (IC_ID_BASE + 0x0337)
#define IC_ID_DELETE       (IC_ID_BASE + 0x0338)

#define IC_CDF_DEFAULT_VIEW_ID              ( IC_ID_BASE + 0x0401 )
#define IC_CDF_STANDALONE_MENU_ID           ( IC_ID_BASE + 0x0402 )
#define IC_CDF_EMBEDDED_MENU_ID             ( IC_ID_BASE + 0x0403 )
#define IC_CDF_INPLACE_MENU_ID              ( IC_ID_BASE + 0x0404 )
#define IC_CDF_TOOLBAR_ID                   ( IC_ID_BASE + 0x0405 )
#define IC_CDF_POPUP_MENU_ID                ( IC_ID_BASE + 0x0406 )

#define IC_CDF_FILE_EXT                     ( IC_ID_BASE + 0x0421 )
#define IC_CDF_APP_SHORTNAME                ( IC_ID_BASE + 0x0422 )
#define IC_CDF_APP_LONGNAME                 ( IC_ID_BASE + 0x0423 )
#define IC_CDF_PROT_EDIT_VERB_0             ( IC_ID_BASE + 0x0424 )
#define IC_CDF_CLSID                        ( IC_ID_BASE + 0x0425 )
#define IC_CDF_CLSID_AUX_3                  ( IC_ID_BASE + 0x0426 )
#define IC_CDF_CLSID_AUX_2                  ( IC_ID_BASE + 0x0427 )
#define IC_CDF_CLSID_VERB_1                 ( IC_ID_BASE + 0x0428 )
#define IC_CDF_CLSID_VERB_0                 ( IC_ID_BASE + 0x0429 )

#define IC_CDF_MENU_TEXT_CUT                ( IC_ID_BASE + 0x0440 )
#define IC_CDF_MENU_TEXT_COPY               ( IC_ID_BASE + 0x0441 )
#define IC_CDF_MENU_TEXT_PASTE              ( IC_ID_BASE + 0x0442 )
#define IC_CDF_MENU_TEXT_PASTE_SPECIAL      ( IC_ID_BASE + 0x0443 )
#define IC_CDF_MENU_TEXT_PASTE_LINK         ( IC_ID_BASE + 0x0444 )
#define IC_CDF_MENU_TEXT_ALL                ( IC_ID_BASE + 0x0445 )
#define IC_CDF_MENU_TEXT_CTRLX              ( IC_ID_BASE + 0x0446 )
#define IC_CDF_MENU_TEXT_CTRLC              ( IC_ID_BASE + 0x0447 )
#define IC_CDF_MENU_TEXT_CTRLV              ( IC_ID_BASE + 0x0448 )
#define IC_CDF_MENU_TEXT_RETURN             ( IC_ID_BASE + 0x0449 )
#define IC_CDF_MENU_TEXT_DELETE             ( IC_ID_BASE + 0x0450 )

#endif
