#ifndef _ICHECKBX_
  #define _ICHECKBX_
/*******************************************************************************
* FILE NAME: icheckbx.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*    ICheckBox                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <isetbut.hpp>
#include <irect.hpp>

class ISize;
class IWindowHandle;
class ICheckBoxData;

#pragma pack(4)

class ICheckBox : public ISettingButton  {
typedef ISettingButton
  Inherited;
public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  ICheckBox  (unsigned long id,
              IWindow* parent,
              IWindow* owner,
              const IRectangle& initial= IRectangle(),
              const Style& style = defaultStyle() );

  ICheckBox  (unsigned long id,
              IWindow*      parent);

  ICheckBox  (const IWindowHandle& handle);

virtual
  ~ICheckBox ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, ICheckBox, IWindow,
                        IControl, IButton);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU autoSelect;

static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*------------------------------- Auto Select --------------------------------*/
virtual ICheckBox
  &enableAutoSelect  ( Boolean enable=true ),
  &disableAutoSelect ( );
virtual Boolean
  isAutoSelect       ( ) const;

protected:
/*---------------------------------- Layout ----------------------------------*/
virtual ISize
  calcMinimumSize    ( ) const;

/*---------------------- Event Handling Implementation -----------------------*/

private:
/*--------------------------------- Private ----------------------------------*/
static Style
  currentDefaultStyle;

ICheckBoxData
 *fCheckBoxData;

/*----------------------------- Hidden Functions -----------------------------*/
  ICheckBox       (const ICheckBox&);
  ICheckBox
     &operator=   (const ICheckBox&);
};  // class ICheckBox

INESTEDBITFLAGCLASSFUNCS(Style, ICheckBox);

#pragma pack()

#endif  /* _ICHECKBX_ */
