#ifndef _ICLIPHDR_
#define _ICLIPHDR_
/*******************************************************************************
* FILE NAME: icliphdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IClipboardHandler                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ievent.hpp>
#include <iclipbrd.hpp>

#pragma pack(4)


class IClipboardHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IClipboardHandler ( );
virtual
 ~IClipboardHandler ( );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  clipboardEmptied ( IEvent&         event ) = 0,
  renderFormat     ( IEvent&         event,
                     const IString&  format ) = 0,
  renderAllFormats ( IEvent&         event ) = 0;

}; // IClipboardHandler


#pragma pack()

#endif /* _ICLIPHDR_ */
