#ifndef _ICMD_
  #define _ICMD_
/*******************************************************************************
* FILE NAME: icmd.hpp                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICommand                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>


#pragma pack(4)

class ICommand :public IBase {
typedef IBase
  Inherited;
public:
/*------------------------------- Action Type --------------------------------*/
enum ActionType {
  applicationCommand,
  systemCommand,
  help
  };

/*----------------------- Common Application Commands ------------------------*/
typedef unsigned long
  CommandId;
static const CommandId
  IC_IMPORTU kOpenId,             // IC_ID_OPEN
  IC_IMPORTU kSaveId,             // IC_ID_SAVE
  IC_IMPORTU kPrintId,            // IC_ID_PRINT
  IC_IMPORTU kLocateId,           // IC_ID_LOCATE
  IC_IMPORTU kCutId,              // IC_ID_CUT
  IC_IMPORTU kCopyId,             // IC_ID_COPY
  IC_IMPORTU kPasteId,            // IC_ID_PASTE
  IC_IMPORTU kHelpId,             // IC_ID_HELP
  IC_IMPORTU kBoldId,             // IC_ID_BOLD
  IC_IMPORTU kItalicId,           // IC_ID_ITALIC
  IC_IMPORTU kUnderscoreId,       // IC_ID_UNDERSCORE
  IC_IMPORTU kSettingsId,         // IC_ID_SETTINGS
  IC_IMPORTU kCopyToId,           // IC_ID_COPYTO
  IC_IMPORTU kOkId,               // IC_ID_OK
  IC_IMPORTU kCancelId,           // IC_ID_CANCEL
  IC_IMPORTU kFileOkId,           // IC_ID_FILEOK
  IC_IMPORTU kFileCancelId,       // IC_ID_FILECANCEL
  IC_IMPORTU kFileApplyId,        // IC_ID_FILEAPPLY
  IC_IMPORTU kFontOkId,           // IC_ID_FONTOK
  IC_IMPORTU kFontCancelId,       // IC_ID_FONTCANCEL
  IC_IMPORTU kFontApplyId,        // IC_ID_FONTAPPLY
  IC_IMPORTU kNewId,              // IC_ID_NEW
  IC_IMPORTU kSaveAsId,           // IC_ID_SAVE_AS
  IC_IMPORTU kExitId,             // IC_ID_EXIT
  IC_IMPORTU kUpdateId,           // IC_ID_UPDATE
  IC_IMPORTU kSaveCopyAsId,       // IC_ID_SAVE_COPY_AS
  IC_IMPORTU kUndoId,             // IC_ID_UNDO
  IC_IMPORTU kPasteSpecialId,     // IC_ID_PASTESPECIAL
  IC_IMPORTU kPasteLinkId,        // IC_ID_PASTELINK
  IC_IMPORTU kSelectAllId,        // IC_ID_SELECTALL
  IC_IMPORTU kInsertId,           // IC_ID_INSERT
  IC_IMPORTU kEditLinksId,        // IC_ID_EDITLINKS
  IC_IMPORTU kDeleteId,           // IC_ID_DELETE
  IC_IMPORTU kConvertId,          // IC_ID_CONVERT
  IC_IMPORTU kViewToolbarId,      // IC_ID_TOOLBAR
  IC_IMPORTU kAboutId;            // IC_ID_ABOUT

/*-------------------------- Common System Commands --------------------------*/
static const CommandId
  IC_IMPORTU kCloseId,            // IC_ID_CLOSE
  IC_IMPORTU kMoveId,             // IC_ID_MOVE
  IC_IMPORTU kSizeId,             // IC_ID_SIZE
  IC_IMPORTU kMinimizeId,         // IC_ID_MINIMIZE
  IC_IMPORTU kMaximizeId,         // IC_ID_MAXIMIZE
  IC_IMPORTU kHideId,             // IC_ID_SYSHIDE
  IC_IMPORTU kRestoreId,          // IC_ID_RESTORE
  IC_IMPORTU kWindowListId;       // IC_ID_WINDOWLIST

private:
/*------------------------------ Hidden Members ------------------------------*/
  ICommand   ( );
  ICommand   ( const ICommand& command );
ICommand
 &operator = ( const ICommand& command );
};  // ICommand

#pragma pack()

#endif /* _ICMD_ */
