#ifndef _ICMDEVT_
#define _ICMDEVT_
/*******************************************************************************
* FILE NAME: icmdevt.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     ICommandEvent                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <ievent.hpp>

#pragma pack(4)

class ICommandEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ICommandEvent ( const IEvent& event );
virtual
 ~ICommandEvent ( );

/*--------------------------- Command Information ----------------------------*/
enum Source {
  pushButton,
  menu,
  accelerator,
  unknown
};

Source
  source      ( ) const;
unsigned long
  commandId   ( ) const;

Boolean
  isFromFrame ( ) const;
}; // ICommandEvent

#pragma pack()

  #include <icmdevt.inl>

#endif /* _ICMDEVT_ */
