#ifndef _ICNRCTL_
#define _ICNRCTL_
/*******************************************************************************
* FILE NAME: icnrctl.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IContainerControl                                                        *
*     IContainerControl::ObjectCursor                                          *
*     IContainerControl::TextCursor                                            *
*     IContainerControl::ColumnCursor                                          *
*     IContainerControl::FilterFn                                              *
*     IContainerControl::CompareFn                                             *
*     IContainerControl::Iterator                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <icontrol.hpp>
#include <icnrobj.hpp>
#include <irect.hpp>

class IContainerControl;
class IContainerColumn;
class IResourceId;
class IPrivateResource;
class IMultiLineEdit;
class IColor;
class ICnrControlList;
class ICnrObjectSet;
class ICnrControlData;
class ICnrObjCursorData;
class ICnrTextCursorData;
class ICnrColCursorData;
struct ICnrInfo;
class ICnrRecord;
class ICnrSortPackage;

#pragma pack(4)


class IContainerControl : public IControl {
typedef IControl
  Inherited;

public:

class Style;
class Attribute;

/*-------------------------- Related Types -----------------------------------*/
enum EnumerationOrder {
  itemOrder,
  zOrder
  };

enum TitleAlignment {
  left,
  right,
  centered
  };

/*------------------------ Constructors --------------------------------------*/
  IContainerControl ( unsigned long     id,
                      IWindow*          parent,
                      IWindow*          owner,
                      const IRectangle& location  = IRectangle(),
                      const Style&      style     = defaultStyle(),
                      const Attribute&  attribute = defaultAttribute());
  IContainerControl ( unsigned long id,
                      IWindow*      parentDialog);

  IContainerControl ( const IWindowHandle& handle);


virtual
 ~IContainerControl ( );

/*-------------------------------- Styles ------------------------------------*/
INESTEDBITFLAGCLASSDEF2( Style, IContainerControl, IWindow, IControl);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU readOnly,
  IC_IMPORTU autoPosition,
  IC_IMPORTU extendedSelection,
  IC_IMPORTU singleSelection,
  IC_IMPORTU multipleSelection,
  IC_IMPORTU verifyPointers,
  IC_IMPORTU noSharedObjects,
  IC_IMPORTU pmCompatible;

static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

Boolean
  isPMCompatible    ( ) const;

/*-------------------------------- Attributes -------------------------------*/
INESTEDBITFLAGCLASSDEF0( Attribute, IContainerControl);

static const Attribute
  IC_IMPORTU textView,
  IC_IMPORTU iconView,
  IC_IMPORTU nameView,
  IC_IMPORTU detailsView,
  IC_IMPORTU treeView,
  IC_IMPORTU flowedView,
  IC_IMPORTU miniIcons,
  IC_IMPORTU readOnlyTitle,
  IC_IMPORTU titleSeparator,
  IC_IMPORTU detailsViewTitles,
  IC_IMPORTU visibleTitle,
  IC_IMPORTU alignTitleCentered,
  IC_IMPORTU alignTitleLeft,
  IC_IMPORTU alignTitleRight,
  IC_IMPORTU handleDrawItem,
  IC_IMPORTU handleDrawBackground,
  IC_IMPORTU orderedTargetEmphasis,
  IC_IMPORTU mixedTargetEmphasis,
  IC_IMPORTU visibleTreeLine,
  IC_IMPORTU classDefaultAttribute;

static Attribute
  defaultAttribute    ( );
static void
  setDefaultAttribute ( const  Attribute& attribute);


/*------------------------ Comparison ----------------------------------------*/
Boolean
  operator==( const IContainerControl& container);

/*------------------------ Initialization ------------------------------------*/
static void
     initialize ( );


class FilterFn : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------ Constructors -----------------------------------*/
  FilterFn ( );

virtual
 ~FilterFn ( );

/*------------------------ Object Filtering -------------------------------*/
virtual Boolean
  isMemberOf  ( IContainerObject* object,
                IContainerControl* container) const = 0;

};  /* end FilterFn */


class CompareFn : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------ Constructors -----------------------------------*/
  CompareFn  ( );

virtual
 ~CompareFn  ( );

/*------------------------ Object Sorting ---------------------------------*/
virtual int
  isEqual     ( IContainerObject* object1,
                IContainerObject* object2,
                IContainerControl* container) const = 0;

};  /* end CompareFn */


class ObjectCursor : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------ Constructors -----------------------------------*/
  ObjectCursor ( const IContainerControl&   container,
                 IContainerObject::Emphasis emphasis    = IContainerObject::none,
                 EnumerationOrder           enumeration = itemOrder);

  ObjectCursor ( const IContainerControl& container,
                 const IContainerObject*  parentObject,
                 Boolean                  allDescendents = false);

virtual
 ~ObjectCursor ( );

/*------------------------ Cursor Movement --------------------------------*/
virtual  Boolean
  setToFirst    ( ),
  setToNext     ( ),
  setToLast     ( ),
  setToPrevious ( );

/*------------------------ Object Retrieval -------------------------------*/
virtual IContainerObject
 *first       ( ),
 *next        ( ),
 *previous    ( ),
 *last        ( ),
 *current     ( ) const;

virtual ObjectCursor
 &setCurrent  ( const IContainerObject* currentObject);

/*------------------------ Cursor Validation ------------------------------*/
virtual  Boolean
  isValid       ( ) const;
virtual ObjectCursor
 &invalidate    ( );

private:

friend class INativeContainerHandler;

IContainerObject
 *object          ( const IContainerObject* objectAfter,
                    unsigned long           command),
 *selectedObject  ( const IContainerObject* objectAfter,
                    unsigned long           emphasis),
 *lastObject      ( const IContainerObject* objectAfter = 0),
 *previousObject  ( const IContainerObject* objectBefore),
 *nextObject      ( const IContainerObject* objectAfter),
 *nextBranchObject( const IContainerObject* objectAfter);

enum State {
  all=1,
  child=2,
  emphasis=4,
  allSubTree=8
  };


IContainerObject
 *pcnrobjClCurrent,
 *pcnrobjClParent;
unsigned long
  ulClChanges;
IContainerControl
 *pcnrctlClOwner;
unsigned long
  flClEmphasis;
unsigned long
  flClEnumeration;
unsigned long
  flClState;
unsigned long
  currentIndex;
ICnrObjCursorData
  *objectCursorData;
};  /* end ObjectCursor */


class TextCursor : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------ Constructors -----------------------------------*/
  TextCursor ( const IContainerControl& container,
               const char*              text,
               Boolean                  isCaseSensitive = true,
               Boolean                  isFirstInRecord = false,
               Boolean                  isExactMatch = false );

virtual
 ~TextCursor ( );

/*------------------------ Cursor Movement --------------------------------*/
virtual  Boolean
  setToFirst    ( ),
  setToNext     ( ),
  setToLast     ( ),
  setToPrevious ( );

/*------------------------ Object Retrieval -------------------------------*/
virtual IContainerObject
  *first       ( ),
  *next        ( ),
  *previous    ( ),
  *last        ( ),
  *current     ( ) const;

virtual TextCursor
 &setCurrent   ( const IContainerObject* currentObject);

/*------------------------ Cursor Validation ------------------------------*/
virtual  Boolean
  isValid      ( ) const;
virtual TextCursor
 &invalidate   ( );

private:
IContainerObject
 *find( unsigned long     view,
        IContainerObject* objectAfter,
        const char*       text,
        Boolean           caseSensitive,
        Boolean           firstInRecord);
IContainerObject
 *pcnrobjClCurrent,
 *pcnrobjClParent;
unsigned long
  ulClView;
unsigned long
  ulClChanges;
IContainerControl
 *pcnrctlClOwner;
IString
  strClSearchString;
Boolean
  fClIsCaseSensitive,
  fClIsFirstInRecord,
  fClIsExactMatch;
ICnrTextCursorData
  *textCursorData;
};  /* end TextCursor */


class ColumnCursor : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------ Constructors -----------------------------------*/
  ColumnCursor  ( const IContainerControl& container,
                  Boolean                  visibleOnly = false );

virtual
 ~ColumnCursor  ( );

/*------------------------ Cursor Movement --------------------------------*/
virtual  Boolean
  setToFirst     ( ),
  setToNext      ( ),
  setToLast      ( ),
  setToPrevious  ( );

/*------------------------ Column Retrieval -------------------------------*/
virtual IContainerColumn
 *first        ( ),
 *next         ( ),
 *previous     ( ),
 *last         ( ),
 *current      ( ) const;

virtual ColumnCursor
 &setCurrent   ( const IContainerColumn* currentColumn);

/*------------------------ Cursor Validation ------------------------------*/
virtual  Boolean
  isValid     ( ) const;
virtual ColumnCursor
 &invalidate  ( );

private:
IContainerColumn
  *pcnrcolClCurrent;
unsigned long
  ulClChanges;
IContainerControl
  *pcnrctlClOwner;
Boolean
  fClVisible;
ICnrColCursorData
  *colCursorData;
};  /* end ColumnCursor */


class Iterator : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------ Constructors ------------------------------------*/
  Iterator    ( );

virtual
 ~Iterator    ( );

/*------------------------ Filter Behavior --------------------------------*/
virtual Boolean
  applyTo     ( IContainerObject* object ) = 0;

};  /* end Iterator */



/*-------------------------------- Appearance --------------------------------*/
virtual IContainerControl
 &setTitle                 ( const char*        title),
 &setTitle                 ( const IResourceId& resourceId),
 &setTitleAlignment        ( TitleAlignment     alignment = centered),
 &showTitle                ( Boolean            show = true),
 &hideTitle                ( );
virtual IContainerControl
 &enableTitleUpdate        ( Boolean            enable = true),
 &disableTitleUpdate       ( );
virtual IContainerControl
 &showTitleSeparator       ( Boolean            show = true),
 &hideTitleSeparator       ( );

virtual IContainerControl
 &showDetailsViewTitles    ( Boolean            show = true),
 &hideDetailsViewTitles    ( );

virtual IContainerControl
 &setLineSpacing           ( long               lineSpacing),
 &setIconSize              ( const ISize&       iconSize);

virtual IContainerControl
 &setSingleSelection       ( ),
 &setMultipleSelection     ( ),
 &setExtendedSelection     ( );

virtual IContainerControl
 &setNormalTargetEmphasis  ( ),
 &setOrderedTargetEmphasis ( ),
 &setMixedTargetEmphasis   ( );

virtual IString
   title                   ( ) const;

Boolean
  areDetailsViewTitlesVisible  ( ) const,
  hasNormalTargetEmphasis      ( ) const,
  hasOrderedTargetEmphasis     ( ) const,
  hasMixedTargetEmphasis       ( ) const,
  isTitleVisible               ( ) const,
  isTitleSeparatorVisible      ( ) const,
  isTitleWriteable             ( ) const;

long
  lineSpacing              ( ) const;

ISize
  iconSize                 ( ) const;

IRectangle
  titleRectangle           ( ) const;

Boolean
  isSingleSelection        ( ) const,
  isMultipleSelection      ( ) const,
  isExtendedSelection      ( ) const;

/*-------------------------- Automatic Deletion Behavior --------------------*/
virtual IContainerControl
 &setDeleteObjectsOnClose  ( Boolean            destroy = true),
 &setDeleteColumnsOnClose  ( Boolean            destroy = true);

Boolean
  willDeleteObjectsOnClose ( ) const,
  willDeleteColumnsOnClose ( ) const;



/*-------------------- Changing Views ----------------------------------------*/
virtual IContainerControl
 &showTextView             ( ),
 &showFlowedTextView       ( ),
 &showNameView             ( ),
 &showFlowedNameView       ( ),
 &showDetailsView          ( ),
 &showTreeIconView         ( ),
 &showTreeTextView         ( ),
 &showTreeNameView         ( ),
 &showIconView             ( );
virtual IContainerControl
 &arrangeIconView          ( );
virtual IContainerControl
 &showMiniIcons            ( Boolean  mini=true );

/*-------------- Determining the View ----------------------------------------*/
Boolean
  isTextView       ( Boolean textOnly=false ) const,
  isNameView       ( Boolean nameOnly=false ) const,
  isIconView       ( Boolean iconOnly=false ) const,
  isDetailsView    ( ) const,
  isTreeView       ( ) const,
  isFlowedTextView ( ) const,
  isFlowedNameView ( ) const,
  isTreeIconView   ( ) const,
  isTreeTextView   ( ) const,
  isTreeNameView   ( ) const,
  isFlowed         ( ) const;

Boolean
  isShowingMiniIcons ( ) const;

/*-------------------- Container Refresh -------------------------------------*/
virtual IContainerControl
 &setRefreshOn           ( Boolean on = true),
 &setRefreshOff          ( ),
 &refresh                ( Boolean immediate=false );

static void
  refreshAllContainers   ( Boolean immediate=false );

Boolean
  isRefreshOn            ( ) const;

/*-------------- Querying the View Port Rectangle ----------------------------*/
IRectangle
  viewPortOnWorkspace         ( ) const,
  viewPortOnWindow            ( ) const,
  detailsViewPortOnWorkspace  ( Boolean rightSide = false) const,
  detailsViewPortOnWindow     ( Boolean rightSide = false) const;

/*------------------- Container Scrolling ------------------------------------*/
virtual IContainerControl
 &scrollVertically           ( long     pixels),
 &scrollHorizontally         ( long     pixels,
                               Boolean  rightSide = false),
 &scroll                     ( long     vericalPixels,
                               long     horizontalPixels,
                               Boolean  rightSide = false),
 &scrollDetailsHorizontally  ( long     horizontalPixels,
                               Boolean  rightSide = false),

 &scrollToObject             ( const IContainerObject* object),
 &scrollToObject             ( const IContainerObject* object,
                               const IContainerColumn* column,
                               Boolean                 leftJustify = true );

/*------------------- Tree View Functions ------------------------------------*/
virtual IContainerControl
 &showTreeLine            ( long   treeLinePixelWidth = -1),
 &hideTreeLine            ( ),
 &setTreeExpandIconSize   ( const  ISize&         sizeIcon),
 &setTreeViewIndent       ( long                  indentPixels = -1),
 &setTreeItemIcons        ( const IPointerHandle& expanded,
                            const IPointerHandle& collapsed),
 &setTreeItemIcons        ( const IResourceId&    expanded,
                            const IResourceId&    collapsed);

virtual IContainerControl
 &collapseTree            ( ),
 &expandTree              ( );

/*------------------- Details View Functions ---------------------------------*/
virtual IContainerControl
 &showSplitBar        ( Boolean showSplitBar=true),
 &hideSplitBar        ( ),
 &setDetailsViewSplit ( const IContainerColumn* lastColumnBeforeSplit,
                        unsigned long           pixelsFromLeft=50);
Boolean
  isColumnRight      ( const IContainerColumn* column) const;

virtual IContainerControl
 &addColumn          ( const IContainerColumn*          column,
                       const IContainerColumn*          afterColumn=0),
 &removeColumn       ( const IContainerColumn*          column),
 &removeColumnAt     ( IContainerControl::ColumnCursor& cursor);

IContainerColumn
 *columnAt           ( unsigned long       index) const,
 *columnAt           ( const ColumnCursor& cursor) const;

IContainerColumn
 *detailsViewSplit   ( ) const;

unsigned long
    columnCount      ( ) const;

unsigned long
    splitBarOffset   ( ) const;

IRectangle
  detailsTitleRectangle  ( Boolean rightSide = false ) const;

/*------------------- Adding and Removing Objects ----------------------------*/
virtual IContainerControl
 &addObjects            ( ICnrAllocator&          allocator,
                          IContainerObject*       parentObject = 0),
 &addObjectsAfter       ( ICnrAllocator&          allocator,
                          const IContainerObject* afterObject,
                          IContainerObject*       parentObject = 0);
virtual IContainerControl
 &addObject             ( const IContainerObject* newObject,
                          IContainerObject*       parentObject = 0),
 &addObjectAfter        ( const IContainerObject* newObject,
                          const IContainerObject* afterObject,
                                IContainerObject* parentObject = 0);

virtual IContainerControl
 &removeObject          ( IContainerObject*                object,
                          Boolean                          allContainers = false),
 &removeObjectAt        ( IContainerControl::ObjectCursor& cursor),
 &removeObjectAt        ( IContainerControl::TextCursor&   cursor),
 &removeSelectedObjects ( ),
 &removeAllObjects      ( ),
 &deleteSelectedObjects ( ),
 &deleteAllObjects      ( );

/*----------------- Moving and Copying Subtrees ------------------------------*/
virtual Boolean
  isMoveValid    ( IContainerObject*  moveObject,
                   IContainerObject*  newParentObject = 0,
                   IContainerControl* newContainer = 0,
                   IContainerObject*  afterObject = 0);
virtual Boolean
  moveObjectTo   ( IContainerObject*  moveObject,
                   IContainerObject*  newParentObject = 0,
                   IContainerControl* newContainer = 0,
                   IContainerObject*  afterObject = 0,
                   const IPoint&      iconViewLocation = IPoint(0,0));
virtual IContainerObject
 *copyObjectTo   ( IContainerObject*  copyObject,
                   IContainerObject*  parentObject = 0,
                   IContainerControl* newContainer = 0,
                   IContainerObject*  afterObject =0,
                   const IPoint&      iconViewLocation = IPoint(0,0));


/*-------------------- Retrieving Objects ------------------------------------*/
virtual IContainerObject
 *objectAt           ( unsigned long                          index) const,
 *objectAt           ( const IContainerControl::ObjectCursor& cursor) const,
 *objectAt           ( const IContainerControl::TextCursor&   cursor) const,
 *parentObject       ( const IContainerObject*                childObject) const;


ICnrObjectSet
  descendentsOf           ( IContainerObject* parentObject) const,
  immediateDescendentsOf  ( IContainerObject* parentObject) const,
  objectList              ( ) const;


unsigned long
  objectCount             ( ) const;

Boolean
   containsObject( const IContainerObject* object) const;

virtual IContainerObject
 *cursoredObject          ( ) const;

/*------------------ Setting Object Attributes -------------------------------*/
virtual IContainerControl
 &setSelected           ( IContainerObject* object,
                           Boolean          select = true),
 &removeSelected        ( IContainerObject* object);

virtual IContainerControl
 &showSourceEmphasis    ( Boolean           source = true),
 &showSourceEmphasis    ( IContainerObject* object,
                          Boolean           source = true),
 &hideSourceEmphasis    ( ),
 &hideSourceEmphasis    ( IContainerObject* object),
 &setInUse              ( IContainerObject* object,
                          Boolean           inUse = true),
 &removeInUse           ( IContainerObject* object),
 &setCursor             ( IContainerObject* object);
virtual IContainerControl
 &enableDataUpdate      ( IContainerObject* object,
                          Boolean           enable=true),
 &disableDataUpdate     ( IContainerObject* object),
 &expand                ( IContainerObject* object),
 &collapse              ( IContainerObject* object),
 &refresh               ( IContainerObject* object,
                          Boolean immediate=false);
virtual IContainerControl
 &enableDrop            ( IContainerObject* object,
                          Boolean           enable=true);

virtual IContainerControl
 &showObject            ( IContainerObject* object,
                          Boolean           visible=true),
 &hideObject            ( IContainerObject* object);

virtual IContainerControl
 &disableDrop           ( IContainerObject* object);

/*------------------ Querying Object Attributes ------------------------------*/
Boolean
  isTarget         ( const IContainerObject* object) const,
  isSource         ( const IContainerObject* object) const;

Boolean
  isSelected       ( const IContainerObject* object) const;

Boolean
  isInUse          ( const IContainerObject* object) const,
  isCursored       ( const IContainerObject* object) const,
  isVisible        ( const IContainerObject* object) const;
Boolean
  isExpanded       ( const IContainerObject* object) const,
  isCollapsed      ( const IContainerObject* object) const,
  isWriteable      ( const IContainerObject* object) const;
Boolean
  isDropOnAble     ( const IContainerObject* object) const;

/*------------------ Object Position -----------------------------------------*/
virtual IContainerControl
 &moveIconTo               ( IContainerObject* object,
                             const IPoint&     point);

IRectangle
  iconRectangle            ( const IContainerObject* object,
                             Boolean                 includeText = false) const,
  detailsObjectRectangle   ( const IContainerObject* object,
                             Boolean                 rightWindow = false ) const,
  detailsObjectRectangle   ( const IContainerObject* object,
                             const IContainerColumn* column) const,
  textRectangle            ( const IContainerObject* object) const,
  convertToWorkspace       ( const IRectangle&       windowRectangle,
                             Boolean                 rightWindow = false) const;

IContainerObject
 *objectUnderPoint         ( const IPoint& point) const;

IContainerColumn
 *columnUnderPoint         ( const IPoint& point) const;

/*------------------------ Sorting Objects -----------------------------------*/
virtual IContainerControl
 &sortByIconText    ( Boolean                             ascending = true),
 &sort              ( const IContainerControl::CompareFn& sortObject);

static long
  nlsCompare        ( const char* text1,
                      const char* text2) ;

/*------------------------ Filtering Objects ---------------------------------*/
virtual IContainerControl
 &filter            ( ),
 &filter            ( const IContainerControl::FilterFn& filterObject);

/*------------------------ Iterating Objects ---------------------------------*/
virtual IContainerControl
 &allObjectsDo      ( IContainerControl::Iterator& iteratorObject,
                      Boolean                      includeDescendents = false);

/*------------------------ Direct Editing ------------------------------------*/
virtual IContainerControl
 &editContainerTitle         ( );
virtual IContainerControl
 &editColumnTitle            ( IContainerColumn* column),
 &editObject                 ( IContainerObject* object,
                               IContainerColumn* column=0),
 &closeEdit                  ( );
virtual IContainerControl
 &setEditMLE                 ( IMultiLineEdit*   editField);
virtual IContainerControl
 &setEditColumn              ( IContainerColumn* column),
 &setEditObject              ( IContainerObject* object);

IMultiLineEdit
 *currentEditMLE             ( )  const;
IContainerColumn
 *currentEditColumn          ( )  const;
IContainerObject
 *currentEditObject          ( )  const;


/*------------------------ Miscellaneous -------------------------------------*/
virtual IContainerControl
 &enableCaching            ( unsigned long deltaValue = 30),
 &disableCaching           ( ),
 &enableDrawItem           ( Boolean enable=true),
 &disableDrawItem          ( ),
 &enableDrawBackground     ( Boolean enable=true),
 &disableDrawBackground    ( );

Boolean
  isCachingEnabled         ( ) const,
  isDrawItemEnabled        ( ) const,
  isDrawBackgroundEnabled  ( ) const;

static IContainerControl
 *containerFromHandle      ( const IWindowHandle& handle);

unsigned long
  numberOfObjectChanges    ( ) const,
  numberOfColumnChanges    ( ) const;

/*-------------------------------- Overrides ---------------------------------*/
virtual IContainerControl
 &refresh ( const IRectangle& invalidRectangle,
            Boolean           immediate ),
 &refresh ( IWindow::RefreshType type );

virtual Boolean
  isVisible               ( ) const;

virtual IColor
  foregroundColor              ( ) const,
  backgroundColor              ( ) const;

virtual IContainerControl
 &resetForegroundColor         ( ),
 &resetBackgroundColor         ( );

virtual IContainerControl
  &setForegroundColor    ( const IColor &color );

virtual IContainerControl
  &setBackgroundColor    ( const IColor &color );


/*----------------------- Notification Members -------------------------------*/
static INotificationId const
  IC_IMPORTU addId,
  IC_IMPORTU removeId,
  IC_IMPORTU selectId,
  IC_IMPORTU enterId,
  IC_IMPORTU titleId,
  IC_IMPORTU titleVisibleId,
  IC_IMPORTU detailsViewTitlesId;

virtual IContainerControl
 &enableNotification ( Boolean enable=true );


protected:
/*----------------------------- Implementation -------------------------------*/
virtual void
  setContainerAttributes    ( unsigned long     attributeToTurnOff,
                              unsigned long     attributeToTurnOn),
  setEmphasis               ( IContainerObject* object,
                              unsigned long     emphasisAttribute,
                              Boolean           setOn=true),
  setAttributes             ( IContainerObject* object,
                              unsigned long     attributeToTurnOn,
                              unsigned long     attributeToTurnOff);

unsigned long
  containerAttributes       ( ) const,
  attributes                ( const IContainerObject* object) const;

IContainerColumn
 *column                    ( IContainerColumn* column,
                              unsigned long     command,
                              Boolean           visible);

virtual unsigned long
  baseRecordSize            ( );

static IWindowHandle
  hwndAllocation            ( );
static ICnrControlList
 &containerList             ( );
static IPrivateResource
 &containerKey              ( );

virtual ISize
 calcMinimumSize            ( ) const;


/*------------------------- Drag and Drop ------------------------------------*/
virtual Boolean
  isDragStarting      ( IEvent& event );

private:
/*------------------------------- Hidden Functions ---------------------------*/
IContainerControl     ( const IContainerControl& container );
IContainerControl
 &operator=           ( const IContainerControl& container );

/*--------------------------------- Private ----------------------------------*/
enum State {
  ok=1,
  noRefresh=2,
  invalid=4,
  autoDeleteObjects=8,
  autoDeleteColumns=16,
  needsRefresh=32
  };

friend class IContainerColumn;
friend class IContainerControl::ColumnCursor;
friend class IContainerControl::ObjectCursor;
friend class IContainerObject;
friend class ICnrEditHandler;
friend class ICnrDestroyHandler;
friend class ICnrControlData;
friend class ICnrObjPrivateData;
friend class ICnrAllocator;
friend class INativeContainerHandler;
friend class IDetailsEditHandler;
friend class IMessageHandler;
friend class IColumnSet;

friend long __stdcall IContainerControl__compare(
                                           const IMiniCnrRecord* pcnrrec1,
                                           const IMiniCnrRecord* pcnrrec2,
                                           ICnrSortPackage*      pSortPackage);

friend Boolean __stdcall pfnCleanUpObjects(ICnrRecord* pRecord,
                                           void* thisCnr);

void
  addContainer        ( ),
  showView            ( unsigned long     viewFlags),
  collectDescendents  ( ICnrObjectSet&    containerSet,
                        IContainerObject* object) const,
  addDefaultHandler   ( ),
  removeDefaultHandler( );

IContainerObject
 *findFirst           ( unsigned long view,
                        const char*   text,
                        Boolean       isCaseSensitive = false,
                        Boolean       isFirstInRecord = false ) const,
 *selectedObject      ( const IContainerObject* objectAfter,
                        unsigned long           emphasis ) const,
 *object              ( const IContainerObject* objectAfter,
                        unsigned long           command ) const;


IRectangle
  viewport            ( unsigned long coordinateSpace,
                        Boolean       rightSplitWindow) const;

static ICnrDestroyHandler
 &destroyHandler         ( );
static void
  setAllocationContainer ( unsigned long handle);

void
  cleanUp();

long
  removeRecords(void* prec, unsigned short number, unsigned short cmd);

void
     containerInfo       ( ICnrInfo* pCnrInfo ) const,
     setContainerInfo    ( ICnrInfo* pCnrInfo, unsigned long flags ),
     setDefaultContainer ( const Attribute& attribute );

IString
  strContainerTitle;

IContainerColumn
 *pcnrcolClSplitbar;

IContainerColumn
 *pcnrcolClEdit;
IContainerObject
 *pcnrobjClEdit;
IMultiLineEdit
 *pmleClEdit;

Boolean
  fClInvalidate;
int
  lClSplitbar,
  flClState;
unsigned long
  ulClDragEvent;
IBitmapHandle
  hbmClIconViewBackground;
unsigned long
  ulClObjectChanges;
unsigned long
  ulClColumnChanges;

static Attribute
  currentDefaultAttribute;
static Style
  currentDefaultStyle;

ICnrControlData
 *ppd;

static int ListViewFindItem(const IWindowHandle& handle,
                            int start, void* lvFindInfo);
};  /* end IContainerControl */



INESTEDBITFLAGCLASSFUNCS(Style, IContainerControl);

#pragma pack()

  #include <icnrctl.inl>


#endif  /* _ICNRCTL_ */
