#ifndef _ICNREHDR_
#define _ICNREHDR_
/*******************************************************************************
* FILE NAME: icnrehdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICnrEditHandler                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <ihandler.hpp>
#include <icnreevt.hpp>

class IHandlerWindow;
class IWindowHandle;
class IMultiLineEdit;

#pragma pack(4)

class ICnrEditHandler : public IHandler {
typedef IHandler
   Inherited;

public:
/*----------------------- Related Members ------------------------------------*/
enum StringType {
  isIString,
  isCharacterPointer
  };


/*-------------------------- Constructors ------------------------------------*/
  ICnrEditHandler    (StringType   stringType = isIString);
virtual
 ~ICnrEditHandler    ( );

/*-------------------------- Event Processing --------------------------------*/
virtual Boolean
  beginEdit            ( ICnrBeginEditEvent&     event),
  reallocateString     ( ICnrReallocStringEvent& event),
  endEdit              ( ICnrEndEditEvent&       event);

Boolean
  isDataIString        ( )  const;

/*---------------------------- Event Dispatching -----------------------------*/
virtual ICnrEditHandler
 &handleEventsFor       ( IContainerControl* container ),
 &stopHandlingEventsFor ( IContainerControl* container );


/*---------------------------- Multiple-Line Edit Processing -----------------*/
virtual void
  setMLEHandler        ( IHandler*  anMLEHandler);

virtual IMultiLineEdit
 *multiLineEdit        ( const IWindowHandle& handleMultiLineEdit);

IHandler
 *mleHandler           ( ) const;

protected:
/*-------------------------- Event Dispatching -------------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event);


private:
IHandler
 *_phdrMLE;
int _stringType;

/*--------------------------- Hidden Members ---------------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window  ),
 &stopHandlingEventsFor ( IWindow* window  );
};

#pragma pack()

  #include <icnrehdr.inl>

#endif
