#ifndef _ICNROBJ_
#define _ICNROBJ_
/*******************************************************************************
* FILE NAME: icnrobj.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IContainerObject                                                         *
*     ICnrAllocator                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <ihandle.hpp>
#include <istring.hpp>

extern "C" {
  #include <stdlib.h>
  }

class ICnrAllocator;
class ICnrControlData;
class ICnrObjPrivateData;
class ICnrRecord;
class IContainerControl;
class IMiniCnrRecord;
class IResourceId;

#pragma pack(4)

class IContainerObject : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------------ Related Members -----------------------------*/
enum Emphasis { none=0, cursored=1, inuse=2, selected=4 };

/*------------------------------- Constructors -------------------------------*/
  IContainerObject ( );
  IContainerObject ( const IString&          string,
                     const IPointerHandle&   iconHandle = 0 );

  IContainerObject ( const IString&          string,
                     const IResourceId&      iconId );

  IContainerObject ( const IResourceId&      nameID,
                     const IResourceId&      iconId );

  IContainerObject ( const IContainerObject& object );

  IContainerObject ( const IString&          string,
                     unsigned long           iconId );

virtual
 ~IContainerObject ( );

/*------------------------------ Characteristics -----------------------------*/
virtual IContainerObject
 &setIcon           ( const IPointerHandle& iconHandle ),
 &setIcon           ( const IResourceId&    iconId ),
 &setIcon           ( unsigned long         iconId ),

 &setIconText       ( const char*           iconText ),
 &setIconText       ( const IString&        iconText ),
 &setIconText       ( const IResourceId&    iconTextId );

virtual IPointerHandle
  icon              ( ) const;
virtual IString
  iconText          ( ) const;

virtual IContainerObject
 &setInUse          ( Boolean            inUse = true,
                      IContainerControl* container = 0 ),
 &removeInUse       ( IContainerControl* container = 0 );

virtual IContainerObject
 &enableDataUpdate  ( Boolean            enable = true,
                      IContainerControl* container = 0 ),
 &disableDataUpdate ( IContainerControl* container = 0 );

virtual IContainerObject
 &enableDrop        ( Boolean            enable = true,
                      IContainerControl* container = 0 ),
 &disableDrop       ( IContainerControl* container = 0 );

virtual IContainerObject
 &show              ( Boolean            show = true,
                      IContainerControl* container = 0 ),
 &hide              ( IContainerControl* container = 0 );

virtual IContainerObject
 &refresh           ( IContainerControl* container = 0,
                      Boolean            immediate = false ),
 &setRefreshOn      ( Boolean            refreshOn = true ),
 &setRefreshOff     ( );

virtual Boolean
  isInUse           ( IContainerControl* container = 0 ) const;
virtual Boolean
  isWriteable       ( IContainerControl* container = 0 ) const;
virtual Boolean
  isDropOnAble      ( IContainerControl* container = 0 ) const;

virtual Boolean
  isVisible         ( IContainerControl* container = 0 ) const;

virtual Boolean
  isRefreshOn       ( ) const;


virtual IContainerObject
  &setOpen          ( Boolean open = true ),
  &setClosed        ( );
virtual Boolean
  isOpen            ( ) const;

/*---------------------------- Object Allocation -----------------------------*/
#ifdef __DEBUG_ALLOC__
void
 *operator new    ( size_t         size,
                    const char*    fileName,
                    size_t         lineNumber );
void
 *operator new    ( size_t         size,
                    const char*    fileName,
                    size_t         lineNumber,
                    ICnrAllocator& allocator );
void
  operator delete ( void*,
                    const char*    fileName,
                    size_t         lineNumber );
#else
void
 *operator new    ( size_t         size );
void
 *operator new    ( size_t         size,
                    ICnrAllocator& allocator );
void
  operator delete ( void* );
#endif

/*--------------------- Derived Class Provided Members -----------------------*/
virtual void
  handleOpen           ( IContainerControl* container ),
  handleInuseChange    ( IContainerControl* container,
                         Boolean            acquired ),
  handleCursoredChange ( IContainerControl* container,
                         Boolean            acquired ),
  handleSelectedChange ( IContainerControl* container,
                         Boolean            acquired ),
  handleTreeCollapse   ( IContainerControl* container ),
  handleTreeExpand     ( IContainerControl* container );

virtual unsigned long
  helpId               ( ) const;

virtual IContainerObject
 *objectCopy           ( );

Boolean
  operator==           ( const IContainerObject& object );

protected:
/*------------------------------ Attributes ----------------------------------*/
virtual IContainerObject
 &setEmphasis       ( unsigned long      emphasisAttribute,
                      Boolean            turnOn = true,
                      IContainerControl* container = 0 ),
 &setAttributes     ( unsigned long      attributeTurnedOff,
                      unsigned long      attributeTurnedOn,
                      IContainerControl* container = 0 ),
 &incrementUseCount ( ),
 &decrementUseCount ( ),
 &setBase           ( const IMiniCnrRecord* baseRecord ),
 &initialize        ( );

IMiniCnrRecord
 *baseRecord        ( );

unsigned long
  useCount          ( ) const;

virtual Boolean
  isAttribute       ( unsigned long      attribute,
                      IContainerControl* container ) const;

private:
/*--------------------------------- Private ----------------------------------*/
friend class ICnrObjPrivateData;
friend class IContainerControl;
friend class ICnrControlData;
friend class IMiniCnrRecord;
friend IMiniCnrRecord* IRecFromObj       ( const IContainerObject* pcnrobj );
friend IWindowHandle IGadgetFromObj      ( IContainerObject*,
                                           IContainerControl*,
                                           IBase::Boolean );
friend Boolean __stdcall pfnDeleteObjects  ( ICnrRecord* pRecord,
                                             void*       p );
friend Boolean __stdcall pfnCleanUpObjects ( ICnrRecord* pRecord,
                                             void*       thisCnr );
friend class INativeContainerHandler;

enum State {
  ok=1,
  opened=2,
  noInvalidate=4,
  hasDescendents=8,
  noRefresh=16,
  invalid=32,
  subclassed=64,
  deleteInProcess=128,
  nestedDelete=256
  };

unsigned long
  iconTextLength ( ) const;
static void
 *newRecord      ( size_t size ),
  deleteRecord   ( void* precord );

int
  flClState;
unsigned long
  ulClUseCount;
IContainerObject
 *pcnrobjClParent;
IMiniCnrRecord
 *pbase;

void
  setDelayedFree ( Boolean delay = true );
Boolean
  isDelayedFree  ( ) const;
Boolean
  delayFree;

ICnrObjPrivateData
 *ppd;

}; // IContainerObject


class ICnrAllocator : public IBase {
typedef IBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ICnrAllocator ( unsigned long num,
                  unsigned long size );

virtual
  ~ICnrAllocator ( );

protected:
/*---------------------------- Object Information ----------------------------*/
void
  *first           ( ) const,
  *next            ( void* pRec ),
  *nextAvailable   ( );
unsigned long
  initialized     ( ) const;
ICnrAllocator
  &updateForInsert ( );

private:
/*----------------------------- Hidden Members -------------------------------*/
ICnrAllocator ( const ICnrAllocator& aCnrAllocator );
ICnrAllocator
  &operator=   ( const ICnrAllocator& cnrAllocator );

/*--------------------------------- Private ----------------------------------*/
friend class IContainerControl;
friend class IContainerObject;
void
  *pFirst,
  *pAvailable;
unsigned long
   numInitialized;
}; // ICnrAllocator

#pragma pack()

  #include <icnrobj.inl>
  #include <icnrobjn.inl>

#endif  /* _ICNROBJ_ */
