#ifndef _ICNROBJ_INL_
#define _ICNROBJ_INL_ 0
/*******************************************************************************
* FILE NAME: icnrobj.inl                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in icnrobj.hpp.                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _ICNROBJ_
  #undef  _ICNROBJ_INL_
  #define _ICNROBJ_INL_ 1
  #include <icnrobj.hpp>
#endif

#if _ICNROBJ_INL_
  #define inline
#endif


inline unsigned long IContainerObject::useCount ( ) const
{
  return ((IContainerObject*)this)->ulClUseCount;
}

inline IMiniCnrRecord* IContainerObject::baseRecord ( )
{
  return ((IContainerObject*)this)->pbase;
}

inline void IContainerObject::setDelayedFree ( Boolean delay )
{
  delayFree = delay;
}

inline Boolean IContainerObject::isDelayedFree ( ) const
{
  return delayFree;
}

inline void* ICnrAllocator::first ( ) const
{
  return pFirst;
}

inline unsigned long ICnrAllocator::initialized ( ) const
{
  return numInitialized;
}

#endif // _ICNROBJ_INL_
