#ifndef _ICNROBJN_INL_
#define _ICNROBJN_INL_ 0
/*******************************************************************************
* FILE NAME: icnrobjn.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline, non-memory-debug version  *
*   of operators new and delete for the classes declared in icnrobj.hpp.       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _ICNROBJ_
  #undef  _ICNROBJN_INL_
  #define _ICNROBJN_INL_ 1
  #include <icnrobj.hpp>
#endif

#if _ICNROBJN_INL_
  #define inline
#endif

#ifndef __DEBUG_ALLOC__
inline void* IContainerObject::operator new ( size_t size )
{
  return newRecord( size );
}

inline void IContainerObject::operator delete ( void *p )
{
  deleteRecord( p );
}
#endif

#endif // _ICNROBJN_INL_
