#ifndef _ICOLOR_INL_
#define _ICOLOR_INL_ 0
/*******************************************************************************
* FILE NAME: icolor.inl                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in icolor.hpp.                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _ICOLOR_
  #undef  _ICOLOR_INL_
  #define _ICOLOR_INL_ 1
  #include <icolor.hpp>
#endif

#if _ICOLOR_INL_
  #define inline
#endif

inline unsigned char IColor::redMix ( ) const
{
  ((IColor*)this)->checkSysRGBValue();
  return ucClRed;
}

inline unsigned char IColor::blueMix ( ) const
{
  ((IColor*)this)->checkSysRGBValue();
  return ucClBlue;
}

inline unsigned char IColor::greenMix ( ) const
{
  ((IColor*)this)->checkSysRGBValue();
  return ucClGreen;
}

inline IBase::Boolean IColor::operator== ( const IColor& color ) const
{
  ((IColor*)this)->checkSysRGBValue();
  if ((ucClRed   == color.ucClRed  ) &&
      (ucClGreen == color.ucClGreen) &&
      (ucClBlue  == color.ucClBlue ))
     return true;
  else
     return false;
}

inline IBase::Boolean IColor::operator != ( const IColor& color ) const
{
  return !(*this == color);
}

inline IColor& IColor::setRed ( unsigned char redMix )
{
  ucClRed = redMix;
  bClColor = false;
  return *this;
}

inline IColor& IColor::setGreen ( unsigned char greenMix )
{
  ucClGreen = greenMix;
  bClColor = false;
  return *this;
}

inline IColor& IColor::setBlue ( unsigned char blueMix )
{
  ucClBlue = blueMix;
  bClColor = false;
  return *this;
}

inline IDeviceColor::DeviceColor IDeviceColor::deviceColor ( ) const
{
  return dcClDeviceColor;
}

inline IColor::SystemColor IGUIColor::systemColor ( ) const
{
  return Inherited::systemColor();
}

#endif // _ICOLOR_INL_
