#ifndef _ICOMBOBS_
  #define _ICOMBOBS_
/*******************************************************************************
* FILE NAME: icombobs.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBaseComboBox                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ientryfd.hpp>
#include <irect.hpp>

class IBaseComboBoxData;
class IBaseComboBoxCursorData;
class IComboBoxHandler;

#pragma pack(4)

class IBaseComboBox : public IEntryField {
typedef IEntryField
  Inherited;

public:
class Style;
class Cursor;
/*------------------------------- Constructors -------------------------------*/
  IBaseComboBox       ( unsigned long     id,
                        IWindow*          parent,
                        IWindow*          owner,
                        const IRectangle& initial = IRectangle  ( ),
                        const Style&      style   = defaultStyle( ) );

  IBaseComboBox       ( unsigned long     id,
                        IWindow*          parent );

  IBaseComboBox       ( const IWindowHandle& handle );

virtual
 ~IBaseComboBox       ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IBaseComboBox, IWindow, IControl);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU simpleType,
  IC_IMPORTU dropDownType,
  IC_IMPORTU readOnlyDropDownType,
  IC_IMPORTU horizontalScroll;
static const Style
  IC_IMPORTU autoScroll;
static const Style
  IC_IMPORTU  oemData;
#ifndef IC_MOTIFPM_FLAGNOP
static const Style
  IC_IMPORTU border3D;
#endif

static Style
  defaultStyle        ( );

static void
  setDefaultStyle     ( const Style&    style );

virtual unsigned long
  convertToGUIStyle   ( const IBitFlag& style,
                        Boolean         extendedOnly = false ) const;

Boolean
  isHorizontalScroll  ( ) const;

/*------------------------- Type Members -------------------------------------*/
enum ControlType {
  simple,
  dropDown,
  dropDownList,
  readOnlyDropDown = dropDownList
};

ControlType
  type                ( ) const;

/*-------------------------------- Text Limit --------------------------------*/
virtual IBaseComboBox
 &setLimit  ( unsigned long      textLimit ),
 &setLimit  ( const IResourceId& textLimit );

virtual unsigned long
  limit     ( ) const;

/*------------------------- List Box Operations ------------------------------*/
Boolean
  isListShowing       ( ) const;

virtual IBaseComboBox
 &showList            ( Boolean show=true ),
 &hideList            ( );

/*------------------------- Get and Change Items -----------------------------*/
virtual IString
  itemText            ( unsigned long      index ) const;

virtual IBaseComboBox
 &setItemText         ( unsigned long      index,
                        const char*        string,
                        Boolean            updateEntryField = false ),
 &setItemText         ( unsigned long      index,
                        const IResourceId& string,
                        Boolean            updateEntryField = false );

virtual IString
  elementAt           ( const Cursor& cursor ) const;

/*------------------------- Selection ----------------------------------------*/
virtual IBaseComboBox
 &select              ( unsigned long index,
                        Boolean       select = true ),
 &deselect            ( unsigned long index ),
 &deselectAll         ( );

virtual Boolean
  isSelected          ( unsigned long index ) const;

virtual unsigned long
  numberOfSelections  ( ) const;

virtual long
  selection           ( ) const;

/*------------------------- Scrolling Members --------------------------------*/
virtual IBaseComboBox
 &setTop              ( unsigned long index );

virtual unsigned long
  top                 ( ) const;

/*------------------------- Attributes ---------------------------------------*/
virtual Boolean
  hasFocus            ( ) const;

/*--------------------- Read-Only Operation Overrides ------------------------*/
virtual IBaseComboBox
 &enableDataUpdate   ( Boolean update=true );

Boolean
  isWriteable        ( ) const;

/*------------------------- Handle Members -----------------------------------*/
virtual IBaseComboBox
 &setItemHandle       ( unsigned long index,
                        unsigned long handle );

virtual unsigned long
  itemHandle          ( unsigned long index ) const;

/*------------------------- Search List --------------------------------------*/
static const unsigned long
  IC_IMPORTU notFound,
  IC_IMPORTU first;

enum SearchType {
  prefix,
  substring,
  exactMatch
};

virtual unsigned long
  locateText           ( const char*   searchString,
                         Boolean       caseSensitive = true,
                         SearchType    search        = exactMatch,
                         unsigned long index         = first ) const;

/*------------------------- Content ------------------------------------------*/
virtual unsigned long
  count                ( ) const;

virtual Boolean
  isEmpty              ( ) const;


/*------------------------- Color --------------------------------------------*/

/*------------------------- Window Positioning -------------------------------*/

virtual IRectangle
  nativeRect           ( ) const;


/*------------------------- Notification Members -----------------------------*/
static INotificationId const
  IC_IMPORTU enterId,
  IC_IMPORTU selectId;

virtual IBaseComboBox
 &enableNotification   ( Boolean enable = true );

/*------------------------- Layout Support -----------------------------------*/
virtual IRectangle
  layoutAdjustment     ( ) const,
  visibleRectangle     ( ) const;

virtual IBaseComboBox
 &setMinimumRows       ( unsigned long minimumRows );

unsigned long
  minimumRows          ( ) const;


class Cursor : public IVBase {

public:
/*---------------------- Filters --------------------------------*/
enum Filter {
  selectedItems,
  allItems
};

/*------------------------------- Constructors -------------------------------*/
  Cursor               ( const IBaseComboBox& comboBox,
                         Filter               type = selectedItems );
virtual
  ~Cursor              ( );

/*---------------------- Cursor Movement ------------------------*/
virtual Boolean
  setToFirst           ( ),
  setToNext            ( ),
  setToPrevious        ( ),
  setToLast            ( ),
  setToIndex           ( unsigned long index );

/*---------------------- Cursor Validation and Conversion -------*/
virtual Boolean
  isValid              ( ) const;

virtual void
  invalidate           ( );

virtual unsigned long
  asIndex              ( ) const;


private:
/*------------------------------ Hidden Members ------------------------------*/
Cursor                 ( const Cursor& cursor );
Cursor
 &operator=            ( const Cursor& cursor );

/*--------------------------------- Private ----------------------------------*/
const IBaseComboBox
 &rlbCl;
unsigned long
  lClCurrent;
Filter
  cursorTypeCl;
unsigned long
  sameValidation;

IBaseComboBoxCursorData
 *fCursorData;
};


protected:
/*---------------------------- Layout Support --------------------------------*/
virtual ISize
  calcMinimumSize      ( ) const;



/*------------------------------ Item Changes --------------------------------*/
unsigned long
  changeCount          ( ) const;

void
  incrementChangeCount ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
IBaseComboBox          ( const IBaseComboBox& comboBox );
IBaseComboBox
 &operator=            ( const IBaseComboBox& comboBox );

/*--------------------------------- Private ----------------------------------*/
friend class IBaseComboBox::Cursor;
friend class IBaseComboBoxData;
friend class IComboBoxHandler;

friend class IBaseComboHandler;
friend long  __stdcall
   icomboboxEntryWinProc(void*         hwnd,
                         unsigned int  msg,
                         unsigned int  mp1,
                         long          mp2);

IEntryField::Alignment
  alignment            ( ) const;
virtual IBaseComboBox
 &setAlignment         ( IEntryField::Alignment alignment );

static Style
  currentDefaultStyle;

unsigned long
  needValidation;

IBaseComboBoxData
 *fBaseComboBoxData;
};  /* IBaseComboBox */

INESTEDBITFLAGCLASSFUNCS(Style, IBaseComboBox);

#pragma pack()

#endif  /* _ICOMBOBS_ */
