#ifndef _ICOMBOVW_
  #define _ICOMBOVW_
/*******************************************************************************
* FILE NAME: icombovw.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICollectionViewComboBox                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <icombobs.hpp>
#include <istrgen.hpp>
#include <icolobsv.hpp>
#include <irect.hpp>
#include <inotify.hpp>

class IString;
class IWindowHandle;
template <class Element, class Collection> class ICollectionViewComboBoxData;

#pragma implementation("icombovw.c")
#pragma define(ISequence <unsigned long > )
#pragma pack(4)


template <class Element, class Collection>
  class ICollectionViewComboBox : public IBaseComboBox
{
typedef IBaseComboBox
  Inherited;
#pragma define(ICollectionObserver< Element, ICollectionViewComboBox<Element,Collection>, Collection > )

public:

/*------------------------- Constructors -------------------------------------*/
  ICollectionViewComboBox ( unsigned long                    identifier,
                            IWindow*                         parent,
                            IWindow*                         owner,
                            const IRectangle&                initial =
                               IRectangle  ( ),
                            const IBaseComboBox::Style&      style   =
                               IBaseComboBox::defaultStyle( ),
                            const IStringGenerator<Element>& stringGenerator =
                               IStringGenerator<Element>( ) );

  ICollectionViewComboBox ( unsigned long                    identifier,
                            IWindow*                         parent,
                            const IStringGenerator<Element>& stringGenerator =
                               IStringGenerator<Element>( ) );

  ICollectionViewComboBox ( const IWindowHandle&             handle,
                            const IStringGenerator<Element>& stringGenerator =
                               IStringGenerator<Element>( ) );

virtual
 ~ICollectionViewComboBox ( );


/*------------------------- Collection ---------------------------------------*/
virtual Collection
 *items                   ( ) const;

virtual ICollectionViewComboBox<Element,Collection>
 &setItems                ( Collection* collection );

/*------------------------- String Generator ---------------------------------*/
virtual IStringGenerator<Element>
 &setStringGenerator      ( const IStringGenerator<Element>& stringGenerator );

virtual IStringGenerator<Element>
 &stringGenerator         ( );

/*------------------------- Collection-Reporting Protocol --------------------*/
virtual ICollectionViewComboBox<Element,Collection>
 &elementChanged             ( unsigned long   position,
                               const Element&  element  ),
 &elementAdded               ( unsigned long   position,
                               const Element&  element  ),
 &elementDeleted             ( unsigned long   position ),
 &elementsChanged            ( ),
 &collectionReplaced         ( );

/*------------------------- Selection ----------------------------------------*/
static const unsigned long
  noSelection;

virtual ICollectionViewComboBox<Element, Collection>
 &select                     ( unsigned long   collectionPosition,
                               Boolean         select = true ),
 &deselect                   ( unsigned long   collectionPosition );

virtual Element
  selectedElement            ( ) const;

virtual unsigned long
  selectedCollectionPosition ( );

/*------------------------- Notification Members -----------------------------*/
static INotificationId const
  itemChangedId,
  itemsId;

private:
/*------------------------- Hidden Members -----------------------------------*/
  ICollectionViewComboBox
             ( const ICollectionViewComboBox< Element, Collection > & source );
ICollectionViewComboBox<Element,Collection>
 &operator=  ( const ICollectionViewComboBox< Element, Collection > & source );

/*------------------------- Private ------------------------------------------*/
ICollectionViewComboBoxData<Element, Collection>
 *fCollectionViewComboBoxData;

unsigned long
  insert     ( unsigned long    index,
               const char*      text  ),
  deleteItem ( unsigned long    index );

ICollectionViewComboBox<Element, Collection>
 &deleteAll  ( );

}; // ICollectionViewComboBox<Element,Collection>

#if ! defined (__TEMPINC__)
#include <icombovw.c>
#endif


#pragma pack()

#endif // _ICOMBOVW_
