/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ICONNECT_H
#define _ICONNECT_H

#include <iglobals.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#define IInheritFrom(impl)\
  typedef ICursorImpl ICursor;\
  typedef IACollectionImpl IACollection;\
  typedef impl::ImplType Inherited;\
  typedef impl::ElementType ElementType;\
  typedef impl::KeyType KeyType

#define IOverride(func) IOverride_##func

#define IInherited(func) IInherited_##func

#define IOverride_add\
  IBoolean Add (void const* e, ICursorImpl& c)\
  { return add (*(ElementType const*)e, c); }

#define IInherited_add(e,c)\
  Inherited::Add (&e, c)

#define IOverride_addAllFrom\
  void AddAllFrom (IACollectionImpl const& c)\
  { addAllFrom (c); }

#define IInherited_addAllFrom(c)\
  Inherited::AddAllFrom (c)

#define IOverride_addAsFirst\
  void AddAsFirst (void const* e, ICursorImpl& c)\
  { addAsFirst (*(ElementType const*)e, c); }

#define IInherited_addAsFirst(e,c)\
  Inherited::AddAsFirst (&e, c)

#define IOverride_addAsLast\
  void AddAsLast (void const* e, ICursorImpl& c)\
  { addAsLast (*(ElementType const*)e, c); }

#define IInherited_addAsLast(e,c)\
  Inherited::AddAsLast (&e, c)

#define IOverride_addAsNext\
  void AddAsNext (void const* e, ICursorImpl& c)\
  { addAsNext (*(ElementType const*)e, c); }

#define IInherited_addAsNext(e,c)\
  Inherited::AddAsNext (&e, c)

#define IOverride_addAsPrevious\
  void AddAsPrevious (void const* e, ICursorImpl& c)\
  { addAsPrevious (*(ElementType const*)e, c); }

#define IInherited_addAsPrevious(e,c)\
  Inherited::AddAsPrevious (&e, c)

#define IOverride_addAtPosition\
  void AddAtPosition (IPosition p, void const* e, ICursorImpl& c)\
  { addAtPosition (p, *(ElementType const*)e, c); }

#define IInherited_addAtPosition(p,e,c)\
  Inherited::AddAtPosition (p, &e, c)

#define IOverride_addDifference(t)\
  typedef IA##t##Impl IA##t;\
  void AddDifference (IA##t const& c1, IA##t const& c2)\
  { addDifference (c1, c2); }

#define IInherited_addDifference(c1,c2)\
  Inherited::AddDifference (c1, c2)

#define IOverride_addIntersection(t)\
  typedef IA##t##Impl IA##t;\
  void AddIntersection (IA##t const& c1, IA##t const& c2)\
  { addIntersection (c1, c2); }

#define IInherited_addIntersection(c1,c2)\
  Inherited::AddIntersection (c1, c2)

#define IOverride_addOrReplaceElementWithKey\
  IBoolean AddOrReplaceElementWithKey (void const* e, ICursorImpl& c)\
  { return addOrReplaceElementWithKey (*(ElementType const*)e, c); }

#define IInherited_addOrReplaceElementWithKey(e,c)\
  Inherited::AddOrReplaceElementWithKey (&e, c)

#define IOverride_addUnion(t)\
  typedef IA##t##Impl IA##t;\
  void AddUnion (IA##t const& c1, IA##t const& c2)\
  { addUnion (c1, c2); }

#define IInherited_addUnion(c1,c2)\
  Inherited::AddUnion (c1, c2)

#define IOverride_allElementsDo\
  IBoolean AllElementsDo (IApplFunc f, void* a)\
  { return allElementsDo\
     ((IBoolean (*) (ElementType const&, void*)f, a); }

#define IInherited_allElementsDo(f,a)\
  Inherited::AllElementsDo ((IApplFunc)f, a)

#define IOverride_anyElement\
  void* Any () const\
  { return (void*)& anyElement (); }

#define IInherited_anyElement()\
  Inherited::Any ()

#define IOverride_compare(t)\
  typedef IA##t##Impl IA##t;\
  void Compare (IA##t const& c, ICompFunc f)\
  { return compare (c, f); }

#define IInherited_compare(c,f)\
  Inherited::Compare (c,f)

#define IOverride_contains\
  IBoolean Contains (void const* e) const\
  { return contains (*(ElementType const*)e); }

#define IInherited_contains(e)\
  Inherited::Contains (&e)

#define IOverride_containsAllFrom\
  IBoolean ContainsAllFrom (IACollectionImpl const& c) const\
  { return containsAllFrom (c); }

#define IInherited_containsAllFrom(c)\
  Inherited::ContainsAllFrom (c)

#define IOverride_containsAllKeysFrom\
  IBoolean ContainsAllKeysFrom (IACollectionImpl const& c) const\
  { return containsAllKeysFrom (c); }

#define IInherited_containsAllKeysFrom(c)\
  Inherited::ContainsAllKeysFrom (c)

#define IOverride_containsElementWithKey\
  IBoolean ContainsElementWithKey (void const* k) const\
  { return containsElementWithKey (*(KeyType const*)k); }

#define IInherited_containsElementWithKey(k)\
  Inherited::ContainsElementWithKey (&k)

#define IOverride_copy\
  IBoolean Copy (IACollectionImpl const& c)\
  { return copy (c); }

#define IInherited_copy(c)\
  Inherited::Copy (c)

#define IOverride_dequeue\
  void RemoveFirst (void* e)\
  { dequeue (*(ElementType*)e); }

#define IInherited_dequeue(e)\
  Inherited::RemoveFirst (&e)

#define IOverride_differenceWith(t)\
  typedef IA##t##Impl IA##t;\
  void Difference (IA##t const& c1, IA##t const& c2)\
  { differenceWith (c1, c2); }

#define IInherited_differenceWith(c1,c2)\
  Inherited::Difference (c1, c2)

#define IOverride_elementAt\
  void* ElementAt (ICursorImpl const& c) const\
  { return (void*)& elementAt (c); }

#define IInherited_elementAt(c)\
  Inherited::ElementAt (c)

#define IOverride_elementAtPosition\
  void* ElementAtPosition (IPosition p) const\
  { return (void*)& elementAtPosition (p); }

#define IInherited_elementAtPosition(p)\
  Inherited::ElementAtPosition (p)

#define IOverride_elementWithKey\
  void* ElementAt (void const* k) const\
  { return (void*)& elementWithKey (*(KeyType const*)k); }

#define IInherited_elementWithKey(k)\
  Inherited::ElementWithKey (&k)

#define IOverride_enqueue\
  void Add (void const* e, ICursorImpl& c) const\
  { enqueue (*(ElementType const*)e, c); }

#define IInherited_enqueue(e,c)\
  Inherited::Add (&e,c)

#define IOverride_firstElement\
  void* First () const\
  { return (void*)& firstElement (); }

#define IInherited_firstElement()\
  Inherited::First ()

#define IOverride_intersectionWith(t)\
  typedef IA##t##Impl IA##t;\
  void Intersection (IA##t const& c1, IA##t const& c2)\
  { intersectionWith (c1, c2); }

#define IInherited_intersectionWith(c1,c2)\
  Inherited::Intersection (c1, c2)

#define IOverride_isEmpty\
  IBoolean IsEmpty () const\
  { return isEmpty (); }

#define IInherited_isEmpty()\
  Inherited::IsEmpty ()

#define IOverride_isFirst\
  IBoolean IsFirstAt (ICursorImpl const& c) const\
  { return isFirst (c); }

#define IInherited_isFirst(c)\
  Inherited::IsFirstAt (c)

#define IOverride_isFull\
  IBoolean IsFull () const\
  { return isFull (); }

#define IInherited_isFull()\
  Inherited::IsFull ()

#define IOverride_isLast\
  IBoolean IsLastAt (ICursorImpl const& c) const\
  { return isLast (c); }

#define IInherited_isLast(c)\
  Inherited::IsLastAt (c)

#define IOverride_key\
  void* Key (void const* e) const\
  { return (void*)& key (*(ElementTpye const*)e); }

#define IInherited_key(e)\
  Inherited::Key (&e)

#define IOverride_lastElement\
  void* Last () const\
  { return (void*)& lastElement (); }

#define IInherited_lastElement()\
  Inherited::Last ()

#define IOverride_locate\
  IBoolean Locate (void const* e, ICursorImpl& c)\
  { return locate (*(ElementType const*)e, c); }

#define IInherited_locate(e,c)\
  Inherited::Locate (&e,c)

#define IOverride_locateElementWithKey\
  IBoolean LocateElementWithKey (void const* k, ICursorImpl& c)\
  { return locateElementWithKey (*(KeyType const*)k, c); }

#define IInherited_locateElementWithKey(k,c)\
  Inherited::LocateElementWithKey (&k,c)

#define IOverride_locateFirst\
  IBoolean LocateFirst (void const* e, ICursorImpl& c)\
  { return locateFirst (*(ElementType const*)e, c); }

#define IInherited_locateFirst(e,c)\
  Inherited::LocateFirst (&e,c)

#define IOverride_locateLast\
  IBoolean LocateLast (void const* e, ICursorImpl& c)\
  { return locateLast (*(ElementType const*)e, c); }

#define IInherited_locateLast(e,c)\
  Inherited::LocateLast (&e,c)

#define IOverride_locateNext\
  IBoolean LocateNext (void const* e, ICursorImpl& c)\
  { return locateNext (*(ElementType const*)e, c); }

#define IInherited_locateNext(e,c)\
  Inherited::LocateNext (&e,c)

#define IOverride_locateNextElementWithKey\
  IBoolean LocateNextElementWithKey (void const* e, ICursorImpl& c)\
  { return locateNextElementWithKey (*(ElementType const*)e, c); }

#define IInherited_locateNextElementWithKey(k,c)\
  Inherited::LocateNetxElementWithKey (&k,c)

#define IOverride_locateOrAdd\
  IBoolean LocateOrAdd (void const* e, ICursorImpl& c)\
  { return locateOrAdd (*(ElementType const*)e, c); }

#define IInherited_locateOrAdd(e,c)\
  Inherited::LocateOrAdd (&e,c)

#define IOverride_locateOrAddElementWithKey\
  IBoolean LocateOrAddElementWithKey (void const* e, ICursorImpl& c)\
  { return locateOrAddElementWithKey\
      (*(ElementType const*)Element, c); }

#define IInherited_locateOrAddElementWithKey(e,c)\
  Inherited::LocateOrAddElementWithKey (&e,c)

#define IOverride_locatePrevious\
  IBoolean LocatePrevious (void const* e, ICursorImpl& c)\
  { return locatePrevious (*(ElementType const*)e, c); }

#define IInherited_locatePrevious(e,c)\
  Inherited::LocatePrevious (&e,c)

#define IOverride_maxNumberOfElements\
  INumber MaxNumberOfElements () const\
  { return maxNumberOfElements (); }

#define IInherited_maxNumberOfElements()\
  Inherited::MaxNumberOfElements ()

#define IOverride_newCursor\
  Cursor* CreateCursor () const\
  { return newCursor (); }

#define IInherited_newCursor()\
  Inherited::CreateCursor ()

#define IOverride_numberOfDifferentElements\
  INumber NumberOfDifferentElements () const\
  { return numberOfDifferentElements (); }

#define IInherited_numberOfDifferentElements()\
  Inherited::NumberOfDifferentElements ()

#define IOverride_numberOfDifferentKeys\
  INumber NumberOfDifferentKeys () const\
  { return numberOfDifferentKeys (); }

#define IInherited_numberOfDifferentKeys()\
  Inherited::NumberOfDifferentKeys ()

#define IOverride_numberOfElements\
  INumber NumberOfElements () const\
  { return numberOfElements (); }

#define IInherited_numberOfElements()\
  Inherited::NumberOfElements ()

#define IOverride_numberOfElementsWithKey\
  INumber NumberOfElementsWithKey (void const* k) const\
  { return numberOfElementsWithKey (*(KeyType const*)k); }

#define IInherited_numberOfElementsWithKey(k)\
  Inherited::NumberOfElementsWithKey (&k)

#define IOverride_numberOfOccurrences\
  INumber NumberOfOccurrences (void const* e) const\
  { return numberOfOccurrences (*(ElementType const*)e); }

#define IInherited_numberOfOccurrences(e)\
  Inherited::NumberOfOccurrences (&e)

#define IOverride_pop\
  void RemoveLast (void* e)\
  { pop (*(ElementType*)e); }

#define IInherited_pop(e)\
  Inherited::RemoveLast (&e)

#define IOverride_positionAt\
  IPosition PositionAt (ICursorImpl const& c) const\
  { return positionAt (c); }

#define IInherited_positionAt(c)\
  Inherited::PositionAt (c)

#define IOverride_push\
  void Add (void const* e, ICursorImpl& c) const\
  { push (*(ElementType const*)e, c); }

#define IInherited_push(e,c)\
  Inherited::Add (&e,c)

#define IOverride_remove\
  IBoolean Remove (void const* e)\
  { return remove (*(ElementType const*)e); }

#define IInherited_remove(e)\
  Inherited::Remove (&e)

#define IOverride_removeAllElementsWithKey\
  INumber RemoveAllElementsWithKey (void const* k)\
  { return removeAllElementsWithKey (*(KeyType const*)k); }

#define IInherited_removeAllElementsWithKey(k)\
  Inherited::RemoveAllElementsWithKey (&k)

#define IOverride_removeAllOccurrences\
  IBoolean RemoveAllOccurrences (void const* e)\
  { return removeAllOccurrences (*(ElementType const*)e); }

#define IInherited_removeAllOccurrences(e)\
  Inherited::RemoveAllOccurrences (&e)

#define IOverride_removeAll\
  INumber RemoveAll ()\
  { return removeAll (); }

#define IInherited_removeAll()\
  Inherited::RemoveAll ()

#define IOverride_removeAt\
  void RemoveAt (ICursorImpl& c)\
  { removeAt (c); }

#define IInherited_removeAt(c)\
  Inherited::RemoveAt (c)

#define IOverride_removeAtPosition\
  void RemoveAtPosition (IPosition p)\
  { removeAtPosition (p); }

#define IInherited_removeAtPosition(p)\
  Inherited::RemoveAtPosition (p)

#define IOverride_removeElementWithKey\
  IBoolean RemoveElementWithKey (void const* k)\
  { return removeElementWithKey (*(KeyType const*)k); }

#define IInherited_removeElementWithKey(k)\
  Inherited::RemoveElementWithKey (&k)

#define IOverride_removeFirst\
  void RemoveFirst ()\
  { removeFirst (); }

#define IInherited_removeFirst()\
  Inherited::RemoveFirst ()

#define IOverride_removeLast\
  void RemoveLast ()\
  { removeLast (); }

#define IInherited_removeLast()\
  Inherited::RemoveLast ()

#define IOverride_replaceAt\
  void ReplaceAt (ICursorImpl const& c, void const* e)\
  { replaceAt (c, *(ElementType const*)e); }

#define IInherited_replaceAt(c,e)\
  Inherited::ReplaceAt (c,&e)

#define IOverride_replaceElementWithKey\
  void ReplaceElementWithKey (void const* e, ICursorImpl const& c)\
  { replaceElementWithKey (*(ElementType const*)e, c); }

#define IInherited_replaceElementWithKey(e,c)\
  Inherited::ReplaceElementWithKey (&e,c)

#define IOverride_setToFirst\
  IBoolean SetToFirst (ICursorImpl& c) const\
  { return setToFirst (c); }

#define IInherited_setToFirst(c)\
  Inherited::SetToFirst (c)

#define IOverride_setToLast\
  IBoolean SetToLast (ICursorImpl& c) const\
  { return setToLast (c); }

#define IInherited_setToLast(c)\
  Inherited::SetToLast (c)

#define IOverride_setToNext\
  IBoolean SetToNext (ICursorImpl& c) const\
  { return setToNext (c); }

#define IInherited_setToNext(c)\
  Inherited::SetToNext (c)

#define IOverride_setToNextDifferentElement\
  IBoolean SetToNextDifferentElement (ICursorImpl& c) const\
  { return setToNextDifferentElement (c); }

#define IInherited_setToNextDifferentElement(c)\
  Inherited::SetToNextDifferentElement (c)

#define IOverride_setToNextWithDifferentKey\
  IBoolean SetToNextWithDifferentKey (ICursorImpl& c) const\
  { return setToNextWithDifferentKey (c); }

#define IInherited_setToNextWithDifferentKey(c)\
  Inherited::SetToNextWithDifferentKey (c)

#define IOverride_setToPosition\
  void SetToPosition (IPosition p, ICursorImpl& c) const\
  { setToPosition (p, c); }

#define IInherited_setToPosition(p,c)\
  Inherited::SetToPosition (p,c)

#define IOverride_setToPrevious\
  IBoolean SetToPrevious (ICursorImpl& c) const\
  { return setToPrevious (c); }

#define IInherited_setToPrevious(c)\
  Inherited::SetToPrevious (c)

#define IOverride_sort\
  void Sort (ICompFunc f) const\
  { return sort (long (*) (ElementType const&, ElementType const&)f); }

#define IInherited_sort(f)\
  Inherited::Sort ((ICompFunc)f)

#define IOverride_unionWith(t)\
  typedef IA##t##Impl IA##t;\
  void Union (IA##t const& c1, IA##t const& c2)\
  { unionWith (c1, c2); }

#define IInherited_unionWith(c1,c2)\
  Inherited::Union (c1, c2)

#define IOverride_operatorEquality(t)\
  typedef IA##t##Impl IA##t;\
  IBoolean operator== (IA##t const& c)\
  { return operator== (c); }

#define IInherited_operatorEquality(c)\
  Inherited::operator== (c)

#define IConnect(if, impl, iif, e) \
  typedef impl<Self::Instantiation> Implementation;\
  iif##Typedef(e);\
  if (INumber n = 100)\
  : Self (*(Implementation*)*new Instantiation (n)) {}

#define IConnect_WithElementOps(if, impl, iif, e, eo) \
  typedef impl<Self::Instantiation> Implementation;\
  iif##Typedef(e, eo);\
  if (INumber n = 100)\
  : Self (*(Implementation*)*new Instantiation (n)) {}

#define IConnect_WithKey(if, impl, iif, e, k) \
  typedef impl<Self::Instantiation> Implementation;\
  iif##Typedef(e, k);\
  if (INumber n = 100)\
  : Self (*(Implementation*)*new Instantiation (n)) {}

#define IConnect_WithKeyAndElementOps(if, impl, iif, e, k, eo) \
  typedef impl<Self::Instantiation> Implementation;\
  iif##Typedef(e, k, eo);\
  if (INumber n = 100)\
  : Self (*(Implementation*)*new Instantiation (n)) {}

#define IImplOf(c) \
  ((Implementation&)ImplOf (c))

// defines for tree member function

#define IInheritTreeFrom(impl)\
  typedef ITreeCursorImpl ITreeCursor;\
  typedef IATreeImpl IATree;\
  typedef impl Inherited

#define IOverrideTree(func) IOverrideTree_##func

#define IInheritedTree(func) IInheritedTree_##func

#define IOverrideTree_addAsChild\
  IBoolean AddAsChild (ITreeCursorImpl& c, IPosition p, void const* e)\
  { return addAsChild (c, p, *(ElementType const*)e); }

#define IInherited_addAsChild(c,p,e)\
  Inherited::AddAsChild (c, p, &e)

#define IOverrideTree_addAsRoot\
  IBoolean AddAsRoot (void const* e)\
  { return addAsRoot (*(ElementType const*)e); }

#define IInherited_addAsRoot(e)\
  Inherited::AddAsRoot (&e)

#define IOverrideTree_allElementsDo\
  IBoolean AllElementsDo (IApplFunc f, ITreeIterationOrder o, void* a)\
  { return allElementsDo\
     ((IBoolean (*) (ElementType const&, void*)f, o, a); }

#define IInheritedTree_allElementsDo(f,o,a)\
  Inherited::AllElementsDo ((IApplFunc)f, o, a)

#define IOverrideTree_allSubtreeElementsDo\
  IBoolean AllSubtreeElementsDo\
    (ITreeCursorImpl const& c,IApplFunc f,\
     ITreeIterationOrder o, void* a)\
  { return allSubtreeElementsDo\
     (c, (IBoolean (*) (ElementType const&, void*)f, o, a); }

#define IInheritedTree_allSubtreeElementsDo(f,o,a)\
  Inherited::AllSubtreeElementsDo (c, (IApplFunc)f, o, a)

#define IOverrideTree_attachAsChild(t)\
  typedef IA##t##Impl IA##t##;\
  IBoolean AttachAsChild\
    (ITreeCursorImpl& c, IPosition p, IA##t##Impl& tree)\
  { return attachAsChild (c, p, tree); }

#define IInherited_attachAsChild(c,p,t)\
  Inherited::AttachAsChild (c, p, t)

#define IOverrideTree_attachSubtreeAsChild(t)\
  typedef IA##t##Impl IA##t##;\
  IBoolean AttachSubtreeAsChild\
    (ITreeCursorImpl& c1, IPosition p,\
     IA##t##Impl& tree, ITreeCursorImpl const& c2)\
  { return attachSubtreeAsChild (c1, p, tree, c2); }

#define IInherited_attachSubtreeAsChild(c1,p,t,c2)\
  Inherited::AttachSubtreeAsChild (c1, p, t, c2)

#define IOverrideTree_attachAsRoot\
  typedef IA##t##Impl IA##t##;\
  IBoolean AttachAsRoot (IA##t##Impl& tree)\
  { return attachAsRoot (tree); }

#define IInheritedTree_attachAsRoot(t)\
  Inherited::AttachAsRoot (t)

#define IOverrideTree_attachSubtreeAsRoot\
  typedef IA##t##Impl IA##t##;\
  IBoolean AttachSubtreeAsRoot\
    (IA##t##Impl& tree, ITreeCursrImpl const& c)\
  { return attachSubtreeAsRoot (tree, c); }

#define IInheritedTree_attachSubtreeAsRoot(t,c)\
  Inherited::AttachSubtreeAsRoot (t,c)

#define IOverride_childPositionAt\
  IPosition ChildPositionAt (ICursorImpl const& c) const\
  { return childPositionAt (c); }

#define IInherited_childPositionAt(c)\
  Inherited::ChildPositionAt (c)

#define IOverrideTree_copy\
  typedef IA##t##Impl IA##t##;\
  IBoolean Copy (IA##t##Impl const& tree)\
  { return copy (tree); }

#define IInheritedTree_copy(t)\
  Inherited::Copy (t)

#define IOverrideTree_copySubtree\
  typedef IA##t##Impl IA##t##;\
  IBoolean CopySubtree\
    (IA##t##Impl const& tree, ITreeCursrImpl const& c)\
  { return copySubtree (tree, c); }

#define IInheritedTree_copySubtree(t,c)\
  Inherited::CopySubtree (t,c)

#define IOverrideTree_elementAt\
  void* ElementAt (ITreeCursorImpl const& c) const\
  { return (void*)& elementAt (c); }

#define IInheritedTree_elementAt(c)\
  Inherited::ElementAt (c)

#define IOverrideTree_hasChild\
  IBoolean HasChild (IPosition p, ITreeCursorImpl const& c) const\
  { return hasChild (p, c); }

#define IInheritedTree_hasChild(p,c)\
  Inherited::HasChild (p, c)

#define IOverrideTree_isEmpty\
  IBoolean IsEmpty () const\
  { return isEmpty (); }

#define IInheritedTree_isEmpty()\
  Inherited::IsEmpty ()

#define IOverrideTree_isLeaf\
  IBoolean IsLeaf (ITreeCursor const& c) const\
  { return isLeaf (c); }

#define IInheritedTree_isLeaf(c)\
  Inherited::IsLeaf (c)

#define IOverrideTree_isRoot\
  IBoolean IsRoot (ITreeCursor const& c) const\
  { return isRoot (c); }

#define IInheritedTree_isRoot(c)\
  Inherited::IsRoot (c)

#define IOverrideTree_newCursor\
  Cursor* CreateCursor () const\
  { return newCursor (); }

#define IInheritedTree_newCursor()\
  Inherited::CreateCursor ()

#define IOverrideTree_numberOfChildren\
  INumber NumberOfChildren () const\
  { return numberOfChildren (); }

#define IInheritedTree_numberOfChildren()\
  Inherited::NumberOfChildren ()

#define IOverrideTree_numberOfElements\
  INumber NumberOfElements () const\
  { return numberOfElements (); }

#define IInheritedTree_numberOfElements()\
  Inherited::NumberOfElements ()

#define IOverrideTree_numberOfSubtreeElements\
  INumber NumberOfSubtreeElements (ITreeCursorImpl const& c) const\
  { return numberOfSubtreeElements (c); }

#define IInheritedTree_numberOfSubtreeElements(c)\
  Inherited::NumberOfSubtreeElements (c)

#define IOverrideTree_numberOfLeaves\
  INumber NumberOfLeaves () const\
  { return numberOfLeaves (); }

#define IInheritedTree_numberOfLeaves()\
  Inherited::NumberOfLeaves ()

#define IOverrideTree_numberOfSubtreeLeaves\
  INumber NumberOfSubtreeLeaves (ITreeCursorImpl const& c) const\
  { return numberOfSubtreeLeaves (c); }

#define IInheritedTree_numberOfSubtreeLeaves(c)\
  Inherited::NumberOfSubtreeLeaves (c)

#define IOverrideTree_removeAll\
  INumber RemoveAll ()\
  { return removeAll (); }

#define IInheritedTree_removeAll()\
  Inherited::RemoveAll ()

#define IOverrideTree_removeSubtree\
  INumber RemoveSubtree (ITreeCursorImpl const& c) const\
  { return removeSubtree (c); }

#define IInheritedTree_removeSubtree(c)\
  Inherited::RemoveSubtree (c)

#define IOverrideTree_replaceAt\
  void ReplaceAt (ITreeCursorImpl const& c, void const* e)\
  { replaceAt (c, *(ElementType const*)e); }

#define IInheritedTree_replaceAt(c,e)\
  Inherited::ReplaceAt (c,&e)

#define IOverrideTree_setToChild\
  IBoolean SetToChild (IPosition p, ITreeCursorImpl& c) const\
  { return setToChild (p, c); }

#define IInheritedTree_setToChild(p,c)\
  Inherited::SetToChild (p, c)

#define IOverrideTree_setToFirst\
  IBoolean SetToFirst (ITreeCursorImpl& c, ITreeIterationOrder o) const\
  { return setToFirst (c, o); }

#define IInheritedTree_setToFirst(c,o)\
  Inherited::SetToFirst (c, o)

#define IOverrideTree_setToFirstExistingChild\
  IBoolean SetToFirstExistingChild (ITreeCursorImpl& c) const\
  { return setToFirstExistingChild (c); }

#define IInheritedTree_setToFirstExistingChild(c)\
  Inherited::SetToFirstExistingChild (c)

#define IOverrideTree_setToLast\
  IBoolean SetToLast (ITreeCursorImpl& c, ITreeIterationOrder o) const\
  { return setToLast (c, o); }

#define IInheritedTree_setToLast(c,o)\
  Inherited::SetToLast (c, o)

#define IOverrideTree_setToLastExistingChild\
  IBoolean SetToLastExistingChild (ITreeCursorImpl& c) const\
  { return setToLastExistingChild (c); }

#define IInheritedTree_setToLastExistingChild(c)\
  Inherited::SetToLastExistingChild (c)

#define IOverrideTree_setToNext\
  IBoolean SetToNext (ITreeCursorImpl& c, ITreeIterationOrder o) const\
  { return setToNext (c, o); }

#define IInheritedTree_setToNext(c,o)\
  Inherited::SetToNext (c, o)

#define IOverrideTree_setToNextExistingChild\
  IBoolean SetToNextExistingChild (ITreeCursorImpl& c) const\
  { return setToNextExistingChild (c); }

#define IInheritedTree_setToNextExistingChild(c)\
  Inherited::SetToNextExistingChild (c)

#define IOverrideTree_setToParent\
  IBoolean SetToParent (ITreeCursorImpl& c) const\
  { return setToParent (c); }

#define IInheritedTree_setToParent(c)\
  Inherited::SetToParent (c)

#define IOverrideTree_setToPrevious\
  IBoolean SetToPrevious\
    (ITreeCursorImpl& c, ITreeIterationOrder o) const\
  { return setToPrevious (c, o); }

#define IInheritedTree_setToPrevious(c,o)\
  Inherited::SetToPrevious (c, o)

#define IOverrideTree_setToPreviousExistingChild\
  IBoolean SetToPreviousExistingChild (ITreeCursorImpl& c) const\
  { return setToPreviousExistingChild (c); }

#define IInheritedTree_setToPreviousExistingChild(c)\
  Inherited::SetToPreviousExistingChild (c)

#define IOverrideTree_setToRoot\
  IBoolean SetToRoot (ITreeCursorImpl& c) const\
  { return setToRoot (c); }

#define IInheritedTree_setToRoot(c)\
  Inherited::SetToRoot (c)

#pragma info (restore)
#pragma pack ()

#endif
