#ifndef _ICONTEXT_
#define _ICONTEXT_
/*******************************************************************************
* FILE NAME: icontext.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of class(es):                                                  *
*     IContext                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   Portions or this component are based on work originating from Taligent.    *
*   (C) Copyright Taligent, Inc. 1996 - All rights reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>

class IContextNumberSet;
class IContextElementSet;


#define kFastObjectsArraySize 6


#pragma pack(4)


class IContext : public IBase {
typedef IBase
  Inherited;
public:
/*------------------------------ Type Definitions ----------------------------*/
typedef unsigned long
  ObjectNumber;

/*------------------------------- Constructors -------------------------------*/
   IContext  ( );
virtual
  ~IContext  ( );

/*--------------------------- Streaming Support ------------------------------*/
// Methods used internally for streaming.  Not for general public consumption
public:
unsigned long
  count         ( );
const void
 *find          ( ObjectNumber objectNumber );
ObjectNumber 
  add           ( const void*  object, 
                  Boolean&     objectExistsFlag);
IContext
 &reset         ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IContext ( const IContext& context );
const IContext& operator=(const IContext&);

/*----------------------------- Private --------------------------------------*/
IContextNumberSet
 *fNumberToObject;
IContextElementSet
 *fObjectToNumber;

void
 *fFastObjects[kFastObjectsArraySize];
unsigned long
  fCount;


}; // IContext


#pragma pack()

#endif // _ICONTEXT_

