#ifndef _ICSLIDER_
   #define _ICSLIDER_
/*******************************************************************************
* FILE NAME: icslider.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICircularSlider                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <itextctl.hpp>
#include <irect.hpp>

class IRange;
class ISize;
class IResourceId;
class IWindowHandle;
class IBitmapHandle;
class ICircularSliderData;

#pragma pack(4)


class ICircularSlider : public ITextControl {
typedef ITextControl
  Inherited;
public:
class Style;

/*------------------------------ Constructors --------------------------------*/
  ICircularSlider  (unsigned long Identifier,
                    IWindow* parent,
                    IWindow* owner,
                    const IRectangle& initial = IRectangle(),
                    const Style& style = defaultStyle());

  ICircularSlider  (unsigned long Identifier,
                    IWindow* parentAndOwner);

  ICircularSlider  (const IWindowHandle& handle);

virtual
  ~ICircularSlider ();

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, ICircularSlider, IWindow, IControl);

static const Style
  IC_IMPORTU buttons,
  IC_IMPORTU label,
  IC_IMPORTU displayValue,
  IC_IMPORTU jumpToPointer,
  IC_IMPORTU full360,
  IC_IMPORTU midpoint,
  IC_IMPORTU proportionalTicks,
  IC_IMPORTU noTicks,
  IC_IMPORTU circularArm,
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle     ( );
static void
  setDefaultStyle  ( const Style& style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*------------------------------ Arm Operations ------------------------------*/
IRange
  armRange             () const;
long
  value                () const;
unsigned long
  radius               () const,
  rotationIncrement    () const,
  tickSpacing          () const;

ICircularSlider
  &setArmRange         (const IRange& range),
  &setValue            (long value),
  &setRotationIncrement(unsigned long increment),
  &setTickSpacing      (unsigned long tick),
  &setDecrementBitmaps (const IResourceId& leftUp,
                        const IResourceId& leftDown),
  &setDecrementBitmaps (const IBitmapHandle& leftUp,
                        const IBitmapHandle& leftDown),
  &setIncrementBitmaps (const IResourceId& rightUp,
                        const IResourceId& rightDown),
  &setIncrementBitmaps (const IBitmapHandle& rightUp,
                        const IBitmapHandle& rightDown);

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTU valueId,
  IC_IMPORTU trackId;

/*--------------------------- Observer Notification --------------------------*/
virtual ICircularSlider
 &enableNotification ( Boolean enable=true );

protected:
/*------------------------------ Layout Support ------------------------------*/
virtual ISize
  calcMinimumSize() const;

private:
/*------------------------------ Hidden Members ------------------------------*/
  ICircularSlider       ( const ICircularSlider& slider );
ICircularSlider
 &operator=             ( const ICircularSlider& slider );

/*--------------------------------- Private ----------------------------------*/
friend class ICSliderHandler;

static Boolean
  IC_IMPORTU fRegistered;
static Style
  IC_IMPORTU currentDefaultStyle;
void*
  fData;

ICircularSliderData
 *fCircularSliderData;
}; // ICircularSlider

INESTEDBITFLAGCLASSFUNCS(Style, ICircularSlider);


#pragma pack()

#endif /* _ICSLIDER_ */
