#ifndef _ICUSTBEV_
#define _ICUSTBEV_
/*******************************************************************************
* FILE NAME: icustbev.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*    Declaration of the classes:                                               *
*      ICustomButtonDrawEvent                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ictlevt.hpp>
#include <irect.hpp>
#include <igrafctx.hpp>

class ICustomButton;

#pragma pack(4)


class ICustomButtonDrawEvent : public IControlEvent {
typedef IControlEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ICustomButtonDrawEvent (const IEvent&                 event);
  ICustomButtonDrawEvent (const ICustomButtonDrawEvent& event);
  ICustomButtonDrawEvent (const IEvent&                 event,
                          const ISize&                  size );

virtual
 ~ICustomButtonDrawEvent ( );

/*------------------------------ Drawing -------------------------------------*/
IGraphicContext
  &graphicContext    ( ) const;

enum ButtonState {
  buttonUp,
  buttonDown,
  buttonLatched
};

ButtonState
  buttonState () const;

Boolean
  drawUp      () const,
  drawDown    () const,
  drawLatched () const;

IRectangle
  drawingArea () const;

virtual ICustomButtonDrawEvent
  &setDrawingArea ( const IRectangle& rectangle );

Boolean
  isButtonEnabled () const;

/*----------------------------- Custom Button --------------------------------*/
virtual ICustomButton
 *customButton () const;


private:
/*--------------------------------- Private ----------------------------------*/
  ICustomButtonDrawEvent& operator = ( const ICustomButtonDrawEvent& );
IRectangle
  fRectangle;
IGraphicContext
  fGraphicContext;
};


#pragma pack()

#endif /* _ICUSTBEV_ */
