#ifndef _IDATE_INL_
#define _IDATE_INL_ 0
/*******************************************************************************
* FILE NAME: idate.inl                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in idate.hpp.                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IDATE_
  #undef  _IDATE_INL_
  #define _IDATE_INL_ 1
  #include <idate.hpp>
#endif

extern "C"
  {
  #include <time.h>
  }

#if _IDATE_INL_
  #define inline
#endif

inline IDate IDate :: today ( )
  {
  time_t t   = time(0);
  tm     now = *localtime( &t );
  return IDate(  now.tm_year + 1900, now.tm_yday + 1 );
  }
inline IDate :: IDate ( )
  {
  this->julian = this->today().julian;
  }
inline IDate :: IDate ( int   aDay,
                        Month aMonth,
                        int   aYear )
  {
  this->initialize( aMonth, aDay, aYear );
  }
inline IDate :: IDate ( Month aMonth,
                        int   aDay,
                        int   aYear )
  {
  this->initialize( aMonth, aDay, aYear );
  }
inline IDate :: IDate ( const IDate& aDate )
  : julian( aDate.julian )
  {
  }
inline IDate :: IDate ( unsigned long julianDayNumber )
  : julian( julianDayNumber )
  {
  }

inline IDate::DayOfWeek IDate :: dayOfWeek ( ) const
  {
  return (DayOfWeek) ( this->julian % 7 );
  }
inline unsigned long IDate :: julianDate ( ) const
  {
  return this->julian;
  }

inline IBase::Boolean IDate :: operator == ( const IDate &aDate ) const
  {
  return this->julian == aDate.julian;
  }
inline IBase::Boolean IDate :: operator != ( const IDate &aDate ) const
  {
  return this->julian != aDate.julian;
  }
inline IBase::Boolean IDate :: operator <  ( const IDate &aDate ) const
  {
  return this->julian <  aDate.julian;
  }
inline IBase::Boolean IDate :: operator <= ( const IDate &aDate ) const
  {
  return this->julian <= aDate.julian;
  }
inline IBase::Boolean IDate :: operator >  ( const IDate &aDate ) const
  {
  return this->julian >  aDate.julian;
  }
inline IBase::Boolean IDate :: operator >= ( const IDate &aDate ) const
  {
  return this->julian >= aDate.julian;
  }

inline IDate IDate :: operator + ( int numDays ) const
  {
  return IDate( this->julian + numDays );
  }
inline IDate IDate :: operator - ( int numDays ) const
  {
  return IDate( this->julian - numDays );
  }
inline IDate& IDate :: operator += ( int numDays )
  {
  this->julian += numDays;
  return *this;
  }
inline IDate& IDate :: operator -= ( int numDays )
  {
  this->julian -= numDays;
  return *this;
  }
inline long IDate :: operator - ( const IDate &aDate ) const
  {
  return this->julian - aDate.julian;
  }

inline IBase::Boolean IDate :: isValid ( int   aDay,
                                         Month aMonth,
                                         int  aYear )
  {
  return IDate :: isValid( aMonth, aDay, aYear );
  }
inline IBase::Boolean IDate :: isValid ( int  aYear,
                                         int  aDay )
  {
  return ( aYear != 0
           &&
           aDay <= IDate::daysInYear( aYear ) );
  }
#endif // _IDATE_INL_
