
#ifndef _IDBCSBUF_
#define _IDBCSBUF_
/*******************************************************************************
* FILE NAME: idbcsbuf.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDBCSBuffer                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibuffer.hpp>

extern "C" {
#include <stdlib.h>
#include <limits.h>
#include <ctype.h>
#include <string.h>
#ifdef IC_NLS
   #include <wchar.h>
#if defined(IC_PMWIN) || defined(IC_MVS400)
   #include <wctype.h>
#endif
#endif
}

#pragma pack(4)



class IDBCSBuffer : public IBuffer {
public:

#ifdef IC_NLS
/*------------------------------- Comparisons --------------------------------*/
/*  See ibuffer.hpp for definition of Comparison  */

virtual Comparison
  compare ( const void* p,
            unsigned    len ) const;
#endif

/*------------------------- Subset -------------------------------------------*/
virtual IBuffer
 *subString         ( unsigned startPos,
                      unsigned len,
                      char     padCharacter ) const;

#ifdef IC_NLS
virtual IBuffer
 *subString         ( unsigned startPos ) const;

/*--------------------------------- Testing ----------------------------------*/
virtual Boolean
  isAlphanumeric ( ) const,
  isAlphabetic   ( ) const,
  isASCII        ( ) const,
  isControl      ( ) const,
  isDigits       ( ) const,
  isGraphics     ( ) const,
  isHexDigits    ( ) const,
  isLowerCase    ( ) const,
  isPrintable    ( ) const,
  isPunctuation  ( ) const,
  isUpperCase    ( ) const,
  isWhiteSpace   ( ) const;
#endif

/*------------------------- NLS Testing --------------------------------------*/
virtual Boolean
  isMBCS            ( ) const,
  isDBCS            ( ) const,
  isSBCS            ( ) const,
  isValidMBCS       ( ) const,
  isValidDBCS       ( ) const,
  includesMBCS      ( ) const,
  includesDBCS      ( ) const,
  includesSBCS      ( ) const;



/*------------------------- Searches -----------------------------------------*/
virtual unsigned
  indexOf           ( const IStringTest &aTest,
                      unsigned           startPos = 1 ) const,
  indexOf           ( const char        *pString,
                      unsigned           len,
                      unsigned           startPos = 1 ) const,
  indexOfAnyBut     ( const char        *pString,
                      unsigned           len,
                      unsigned           startPos = 1 ) const,
  indexOfAnyBut     ( const IStringTest &aTest,
                      unsigned           startPos = 1 ) const,
  indexOfAnyOf      ( const char        *pString,
                      unsigned           len,
                      unsigned           startPos = 1 ) const,
  indexOfAnyOf      ( const IStringTest &aTest,
                      unsigned           startPos = 1 ) const,
  lastIndexOf       ( const IStringTest &aTest,
                      unsigned           startPos = 1 ) const,
  lastIndexOf       ( const char        *pString,
                      unsigned           len,
                      unsigned           startPos = 0 ) const,
  lastIndexOfAnyBut ( const char        *pString,
                      unsigned           len,
                      unsigned           startPos = 0 ) const,
  lastIndexOfAnyBut ( const IStringTest &aTest,
                      unsigned           startPos = 0 ) const,
  lastIndexOfAnyOf  ( const char        *pString,
                      unsigned           len,
                      unsigned           startPos = 0 ) const,
  lastIndexOfAnyOf  ( const IStringTest &aTest,
                      unsigned           startPos = 0 ) const;


/*------------------------- Editing ------------------------------------------*/
virtual IBuffer
 *center            ( unsigned newLen,
                      char     padCharacter ),
#ifdef IC_NLS
 *change            ( const char* pSource,
                      unsigned    sourceLen,
                      const char* pTarget,
                      unsigned    targetLen,
                      unsigned    startPos,
                      unsigned    numChanges ),
#endif
 *insert            ( const char *pInsert,
                      unsigned    insertLen,
                      unsigned    pos,
                      char        padCharacter ),
 *leftJustify       ( unsigned newLen,
                      char     padCharacter ),
 *lowerCase         ( ),
 *overlayWith       ( const char *overlay,
                      unsigned    len,
                      unsigned    pos,
                      char        padCharacter ),
 *remove            ( unsigned startPos,
                      unsigned numChars ),
 *reverse           ( ),
 *rightJustify      ( unsigned newLen,
                      char     padCharacter ),
 *strip             ( const char             *pChars,
                      unsigned                len,
                      IStringEnum::StripMode  mode ),
 *strip             ( const IStringTest      &aTest,
                      IStringEnum::StripMode  mode ),
 *translate         ( const char *pInputChars,
                      unsigned    inputLen,
                      const char *pOutputChars,
                      unsigned    outputLen,
                      char        padCharacter ),
 *upperCase         ( );

/*------------------------- Allocation ---------------------------------------*/
virtual IBuffer
 *allocate          ( unsigned newLen ) const;

/*------------------------- Queries ------------------------------------------*/
virtual IStringEnum::CharType
  charType          ( unsigned index ) const;

virtual char
 *next              ( const char *prev );

virtual const char
 *next              ( const char *prev ) const;

protected:

/*------------------------- Search Initialization ----------------------------*/
virtual unsigned
  startSearch          ( unsigned startPos,
                         unsigned searchLen ) const,
  startBackwardsSearch ( unsigned startPos,
                         unsigned searchLen ) const;


/*------------------------- Protected Testing --------------------------------*/
Boolean
  isCharValid          ( unsigned    pos,
                         const char *pValidChars,
                         unsigned    numValidChars ) const;


static Boolean
  isSBC                ( char const *pChar );

/*------------------------- Protected Queries --------------------------------*/
const char
 *className            ( ) const;

static size_t
  charLength           ( char const *pChar ),
  maxCharLength        ( );

size_t
  charLength           ( unsigned pos ) const,
  prevCharLength       ( unsigned pos ) const;


friend class IBuffer;

/*------------------------- Protected Constructors ---------------------------*/
  IDBCSBuffer          ( unsigned bufLength );
 ~IDBCSBuffer          ( );


/*------------------------- Protected New Functions --------------------------*/
/*------------- These functions are for Internal use only --------------------*/
#ifdef IC_NLS
#ifdef IC_HAS_RESTARTABLE

static Boolean
  isSBC                ( char const *pChar , mbstate_t *pMBState );

static size_t
  charLength           ( char const *pChar , mbstate_t *pMBState );

size_t
  charLength           ( unsigned pos , mbstate_t *pMBState ) const,
  prevCharLength       ( unsigned pos , mbstate_t *pMBState ) const;
#endif

private:

unsigned
  windexOfAnyBut     ( const IStringTest &aTest,
                       unsigned           startPos = 1 ) const;
#endif



}; // class IDBCSBuffer



#pragma pack()

  #include <idbcsbuf.inl>

#endif // _IDBCSBUF_


