#ifndef _IDBCSBUF_INL_
#define _IDBCSBUF_INL_ 0
/*******************************************************************************
* FILE NAME: idbcsbuf.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in idbcsbuf.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IDBCSBUF_
  #undef  _IDBCSBUF_INL_
  #define _IDBCSBUF_INL_ 1
  #include <idbcsbuf.hpp>
#endif

#if _IDBCSBUF_INL_
  #include <istring.hpp>
  #define inline
#endif

inline size_t IDBCSBuffer :: charLength ( char const* p )
  {

#ifdef IC_NLS
  if (IString::isInternationalized())
  {
  if ( *p == 0 )
     return 1;
  else
  {
   int temp = 0;
   return ( ( (temp = mblen( p, MB_LEN_MAX ) ) > 0) ? temp : 1 );
  }
  }
  else
  {
#endif
  return (IBuffer::isDBCSLead(*p) ? 2 : 1);
  if ( *p == 0 )
     return 1;
  else
  {
   int temp = 0;
   return ( ( (temp = mblen( p, MB_LEN_MAX ) ) > 0) ? temp : 1 );
  }

#ifdef IC_NLS
  }
#endif

  }

inline size_t IDBCSBuffer :: charLength ( unsigned pos ) const
  {
  return charLength ( contents() + pos - 1 );
  }

inline size_t IDBCSBuffer :: maxCharLength ( )
  {
  return MB_CUR_MAX;
  }

inline IBase::Boolean IDBCSBuffer :: isSBC ( char const* p )
  {
  return ( charLength ( p ) == 1 );
  }

#endif // _IDBCSBUF_INL_
