#ifndef _IDDEEVT_
#define _IDDEEVT_
/*******************************************************************************
* FILE NAME: iddeevt.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDDEEvent                                                                *
*     IDDEAcknowledgeEvent                                                     *
*     IDDESetAcknowledgeInfoEvent                                              *
*     IDDEClientAcknowledgeEvent                                               *
*     IDDEServerAcknowledgeEvent                                               *
*     IDDEAcknowledgePokeEvent                                                 *
*     IDDEAcknowledgeExecuteEvent                                              *
*     IDDEDataEvent                                                            *
*     IDDEClientHotLinkEvent                                                   *
*     IDDERequestDataEvent                                                     *
*     IDDEPokeEvent                                                            *
*     IDDEServerHotLinkEvent                                                   *
*     IDDEExecuteEvent                                                         *
*     IDDEEndEvent                                                             *
*     IDDEClientEndEvent                                                       *
*     IDDEBeginEvent                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <istring.hpp>
#include <ievent.hpp>

class IDDEClientConversation;
class IDDETopicServer;
class IDDEEventData;

#pragma pack(4)


class IDDEEvent : protected IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEEvent ( const IEvent&    ddeEvent );
  IDDEEvent ( const IDDEEvent& ddeEvent );

 ~IDDEEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
IString
  item   ( ) const,
  format ( ) const;

/*----------------------------- Event Operators  -----------------------------*/
IDDEEvent& operator=( const IDDEEvent &e );             // 28569

protected:
/*------------------------------ Implementation ------------------------------*/
IDDEEvent
 &setStatus ( unsigned short status ),
 &setBuffer ( IString        dataBuffer );

unsigned short
  status ( ) const;

IString
  buffer ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
friend class IDDEClientConversation;
friend class IDDETopicServer;

IDDEEvent
 &setFormat ( IString format );

// new private members for Win32
void
  loadItem   ( ),
  loadFormat ( ),
  loadStatus ( ),
  loadBuffer ( );

unsigned short
  usClStatus;
IString
  strClItem,
  strClFormat,
  strClData;

IDDEEventData
 *fDDEEventData;
}; // IDDEEvent

class IDDEAcknowledgeEvent : public IDDEEvent {
typedef IDDEEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEAcknowledgeEvent ( const IEvent& ddeEvent );

 ~IDDEAcknowledgeEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
Boolean
  isApplicationBusy   ( ) const,
  isAckPositive       ( ) const,
  isMessageUnderstood ( ) const;

unsigned char
  applicationSpecificData ( ) const;

protected:
/*----------------------------- Transaction Type -----------------------------*/
unsigned short
  transactionType ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
friend class IDDEClientConversation;
friend class IDDETopicServer;

}; // IDDEAcknowledgeEvent

class IDDESetAcknowledgeInfoEvent : public IDDEEvent {
typedef IDDEEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDESetAcknowledgeInfoEvent ( const IEvent&                      ddeEvent );
  IDDESetAcknowledgeInfoEvent ( const IDDESetAcknowledgeInfoEvent& ddeEvent );

 ~IDDESetAcknowledgeInfoEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
IDDESetAcknowledgeInfoEvent
 &setApplicationBusy         ( ),
 &setMessageNotUnderstood    ( ),
 &setApplicationSpecificData ( unsigned char applicationData );

}; // IDDESetAcknowledgeInfoEvent

class IDDEClientAcknowledgeEvent : public IDDEAcknowledgeEvent {
typedef IDDEAcknowledgeEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEClientAcknowledgeEvent ( const IEvent& ddeEvent );

 ~IDDEClientAcknowledgeEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
Boolean
  isAckToRequestData  ( ) const,
  isAckToBeginHotLink ( ) const,
  isAckToEndHotLink   ( ) const;

}; // IDDEClientAcknowledgeEvent

class IDDEServerAcknowledgeEvent : public IDDEAcknowledgeEvent {
typedef IDDEAcknowledgeEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEServerAcknowledgeEvent ( const IEvent& ddeEvent );

 ~IDDEServerAcknowledgeEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
Boolean
  isAckToHotLinkUpdate ( ) const;

IString
  data ( ) const;

}; // IDDEServerAcknowledgeEvent

class IDDEAcknowledgePokeEvent : public IDDEAcknowledgeEvent {
typedef IDDEAcknowledgeEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEAcknowledgePokeEvent ( const IEvent& ddeEvent );

 ~IDDEAcknowledgePokeEvent ( );

/*-------------------------------- Poked Data --------------------------------*/
IString
  pokedData ( ) const;

}; // IDDEAcknowledgePokeEvent

class IDDEAcknowledgeExecuteEvent : public IDDEAcknowledgeEvent {
typedef IDDEAcknowledgeEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEAcknowledgeExecuteEvent ( const IEvent& ddeEvent );

 ~IDDEAcknowledgeExecuteEvent ( );

/*------------------------------ Command String ------------------------------*/
IString
  commands ( ) const;

}; // IDDEAcknowledgeExecuteEvent

class IDDEDataEvent : public IDDESetAcknowledgeInfoEvent {
typedef IDDESetAcknowledgeInfoEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEDataEvent ( const IEvent& ddeEvent );

 ~IDDEDataEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
IString
  data ( ) const;

Boolean
  isAckRequested    ( ) const,
  isDataFromHotLink ( ) const;

}; // IDDEDataEvent

class IDDEClientHotLinkEvent : public IDDESetAcknowledgeInfoEvent {
typedef IDDESetAcknowledgeInfoEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEClientHotLinkEvent ( const IEvent&                 ddeEvent );
  IDDEClientHotLinkEvent ( const IDDEClientHotLinkEvent& ddeEvent );

 ~IDDEClientHotLinkEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
Boolean
  isAckRequested  ( ) const,
  isDataRequested ( ) const;

}; // IDDEClientHotLinkEvent

class IDDERequestDataEvent : public IDDESetAcknowledgeInfoEvent {
typedef IDDESetAcknowledgeInfoEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDERequestDataEvent ( const IEvent& ddeEvent );

 ~IDDERequestDataEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
IDDERequestDataEvent
 &requestAck ( ),
 &setData    ( const char*   dataString ),
 &setData    ( const void*   dataBuffer,
               unsigned long dataLength );

}; // IDDERequestDataEvent

class IDDEPokeEvent : public IDDESetAcknowledgeInfoEvent {
typedef IDDESetAcknowledgeInfoEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEPokeEvent ( const IEvent& ddeEvent );

 ~IDDEPokeEvent ( );

/*-------------------------------- Poked Data --------------------------------*/
IString
  pokedData ( ) const;

}; // IDDEPokeEvent

class IDDEExecuteEvent : public IDDESetAcknowledgeInfoEvent {
typedef IDDESetAcknowledgeInfoEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEExecuteEvent ( const IEvent& ddeEvent );

 ~IDDEExecuteEvent ( );

/*------------------------------ Command String ------------------------------*/
IString
  commands ( ) const;

}; // IDDEExecuteEvent

class IDDEServerHotLinkEvent : public IDDESetAcknowledgeInfoEvent {
typedef IDDESetAcknowledgeInfoEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEServerHotLinkEvent ( const IEvent& ddeEvent );

 ~IDDEServerHotLinkEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
Boolean
  isPacingRequested ( ) const,
  isDataRequested   ( ) const;

}; // IDDEServerHotLinkEvent

class IDDEEndEvent : protected IEvent {
typedef IEvent
  Inherited;
public:
/*---------------------------- Termination Source ----------------------------*/
enum Source { client, server, error };

Source
  sourceOfEnd ( ) const;

/*------------------------------- Constructors -------------------------------*/
  IDDEEndEvent ( const IEvent& ddeEvent,
                 Source        endSource );

 ~IDDEEndEvent ( );

private:
/*--------------------------------- Private ----------------------------------*/
Source
  sourceCl;

}; // IDDEEndEvent

class IDDEClientEndEvent : public IDDEEndEvent {
typedef IDDEEndEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEClientEndEvent ( const IEvent&  ddeEvent,
                       Source         endSource,
                       IString        application,
                       IString        topic );

 ~IDDEClientEndEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
IString
  application ( ) const,
  topic       ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
IString
  strClApp,
  strClTopic;

}; // IDDEClientEndEvent

class IDDEBeginEvent : protected IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEBeginEvent ( const IEvent& ddeBeginEvent );

 ~IDDEBeginEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
IString
  application ( ) const,
  topic       ( ) const;

IDDEBeginEvent
 &setCaseSensitive ( Boolean caseSensitive );

private:
/*----------------------------- Hidden Functions -----------------------------*/
  IDDEBeginEvent ( const IDDEBeginEvent& event );
IDDEBeginEvent&
  operator=      ( const IDDEBeginEvent& event );

/*--------------------------------- Private ----------------------------------*/
friend class IDDEClientConversation;
friend class IDDETopicServer;

Boolean
  isCaseSensitive ( ) const;

IString
  strClApp,
  strClTopic;
Boolean
  bClCaseSens;

}; // IDDEBeginEvent


#pragma pack()

  #include <iddeevt.inl>

#endif /* _IDDEEVT_ */
