#ifndef _IDDETSRV_INL_
#define _IDDETSRV_INL_ 0
/*******************************************************************************
* FILE NAME: iddetsrv.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in iddetsrv.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IDDETSRV_
  #undef  _IDDETSRV_INL_
  #define _IDDETSRV_INL_ 1
  #include <iddetsrv.hpp>
#endif

#if _IDDETSRV_INL_
  #define inline
#endif

inline IWindowHandle IDDETopicServer :: serverHandle ( ) const
{
   return wndhClServer;
}

inline IString IDDETopicServer :: application ( ) const
{
   return strClApplication;
}

inline IString IDDETopicServer :: topic ( ) const
{
   return strClTopic;
}

inline IDDEServerConversationSet& IDDETopicServer :: closedConversations ( ) const
{
   return *pClsdConvSetCl;
}

inline IDDEServerConversationSet& IDDETopicServer :: conversations ( ) const
{
   return *pConvSetCl;
}

inline IDDEServerHotLinkItemSet& IDDETopicServer :: hotLinkItems ( ) const
{
   return *pHLItemSetCl;
}

inline IDDEFormatSet& IDDETopicServer :: formats ( ) const
{
   return *pFormatSetCl;
}

inline IDDEItemAtomSet& IDDETopicServer :: itemAtoms ( ) const
{
   return *pItemAtomSetCl;
}

inline unsigned long IDDETopicServer :: queueHandle ( ) const
{
   return ulClQHandle;
}

#endif // _IDDETSRV_INL_
