#ifndef _IDMCNRIT_
#define _IDMCNRIT_
/*******************************************************************************
* FILE NAME: idmcnrit.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMCnrItem                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <idmitem.hpp>

class IContainerControl;
class IContainerObject;
class IDMCnrItemData;

#pragma pack(4)

class IDMCnrItem : public IDMItem  {
typedef IDMItem
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMCnrItem  ( IContainerControl*     container,
                IContainerObject*      object,
                IDMSourceOperation*    sourceOperation,
                const ISize&           imageOffset);

  IDMCnrItem  ( const IDMItem::Handle& dragItem );

virtual
  ~IDMCnrItem ( );


/*------------------------------ Source Items --------------------------------*/
static Boolean
  generateSourceItems ( IDMSourceOperation* sourceOperation );

virtual unsigned long
  containerId         ( ) const;

virtual IContainerControl
 *sourceContainer     ( ) const;

/*------------------------------ Drop Processing -----------------------------*/
virtual Boolean
  targetDrop ( IDMTargetDropEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/

IContainerControl
 *pContainerCtl;

IDMCnrItemData
 *fDMCnrItemData;

}; // IDMCnrItem

#pragma pack()

#endif // _IDMCNRIT_
