#ifndef _IDMCOMM_
#define _IDMCOMM_
/*******************************************************************************
* FILE NAME: idmcomm.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     Enumerations -                                                           *
*       Source                                                                 *
*       DropIndicator                                                          *
*       RenderCompletion                                                       *
*       DragImageStyle                                                         *
*       DropStyle                                                              *
*       DiscardIndicator                                                       *
*       PrintIndicator                                                         *
*                                                                              *
*     Drag Item Types -                                                        *
*       any                                                                    *
*       binary                                                                 *
*       binaryData                                                             *
*       bitmap                                                                 *
*       container                                                              *
*       containerObject                                                        *
*       file                                                                   *
*       icon                                                                   *
*       plainText                                                              *
*       text                                                                   *
*       unknown                                                                *
*                                                                              *
*     Rendering Mechanisms (RM) -                                              *
*       rmFile                                                                 *
*       rmObject                                                               *
*       rmDiscard                                                              *
*       rmPrint                                                                *
*       rmLibrary                                                              *
*       rmAny                                                                  *
*                                                                              *
*     Rendering Formats (RF) -                                                 *
*       rfUnknown                                                              *
*       rfText                                                                 *
*       rfProcess                                                              *
*       rfSharedMem                                                            *
*       rfObject                                                               *
*       rfAny                                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>

#pragma pack(4)

struct IDM {
/*-------------------------- Direct Manipulation Flags -----------------------*/
  enum Source
  {
    pointingDevice,
    keyboard
  };

  enum DropIndicator
  {
    notOk            = 0x0000,
    ok               = 0x0001,
    operationNotOk   = 0x0002,
    neverOk          = 0x0003
  };

  enum RenderCompletion
  {
    targetSuccessful = 0x0001,
    targetFailed     = 0x0002,
    retry            = 0x0008,
    renderOk         = 0x0010,
    fail             = 0x0020
  };

  enum DragImageStyle
  {
    stack3AndFade,
    allStacked,
    systemImages
  };

  enum DropStyle
  {
    notContainer   = 0x0000,
    dropAtPosition = 0x0001,
    alignVertical  = 0x0002,
    alignFlow      = 0x0004,
    flowBeside     = 0x0008
  };

  enum DiscardIndicator
  {
    sourceDiscards = 0x0001,
    targetDiscards = 0x0002,
    abortDiscard   = 0x0003
  };

  enum PrintIndicator
  {
    sourcePrints   = 0x0001,
    targetPrints   = 0x0002,
    abortPrint     = 0x0003
  };

/*------------------------------- Drag Item Types ----------------------------*/
typedef const char* Type;
  static Type const
    IC_IMPORTU any,
    IC_IMPORTU binary,
    IC_IMPORTU binaryData,
    IC_IMPORTU bitmap,
    IC_IMPORTU container,
    IC_IMPORTU containerObject,
    IC_IMPORTU file,
    IC_IMPORTU icon,
    IC_IMPORTU menuItem,
    IC_IMPORTU plainText,
    IC_IMPORTU text,
    IC_IMPORTU toolBarButton,
    IC_IMPORTU unknown;

/*----------------------------- Rendering Mechanisms -------------------------*/
typedef const char* RM;
  static RM const
    IC_IMPORTU rmFile,
    IC_IMPORTU rmObject,
    IC_IMPORTU rmDiscard,
    IC_IMPORTU rmPrint,
    IC_IMPORTU rmLibrary,
    IC_IMPORTU rmAny;

/*------------------------------ Rendering Formats ---------------------------*/
typedef const char* RF;
  static RF const
    IC_IMPORTU rfUnknown,
    IC_IMPORTU rfText,
    IC_IMPORTU rfProcess,
    IC_IMPORTU rfSharedMem,
    IC_IMPORTU rfObject,
    IC_IMPORTU rfAny;
};

#pragma pack()

#endif
