#ifndef _IDMEFIT_
#define _IDMEFIT_
/*******************************************************************************
* FILE NAME: idmefit.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMEFItem                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <idmitem.hpp>

class IDMSourceOperation;
class IDMEFItemData;

#pragma pack(4)

class IDMEFItem : public IDMItem {
typedef IDMItem
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMEFItem  ( IDMSourceOperation*    sourceOperation );

  IDMEFItem  ( const IDMItem::Handle& dragItem );

virtual
  ~IDMEFItem ( );


/*------------------------------ Source Items --------------------------------*/
static Boolean
  generateSourceItems ( IDMSourceOperation* sourceOperation );

virtual void
 *object              ( ) const;

/*------------------------------ Drop Processing -----------------------------*/
virtual Boolean
  sourceEnd  ( IDMSourceEndEvent&  event ),
  targetDrop ( IDMTargetDropEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/

IDMEFItemData
 *fDMEFItemData;

}; // IDMEFItem

#pragma pack()

#endif // _IDMEFIT_
