#ifndef _IDMMENIT_
#define _IDMMENIT_
/*******************************************************************************
* FILE NAME: idmmenit.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMMenuItem                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef IC_WIN_FLAGNOP
#include <idmitem.hpp>

class IDMSourceOperation;
class IDMMenuItemData;

#pragma pack(4)

class IDMMenuItem : public IDMItem {
typedef IDMItem
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMMenuItem  ( IDMSourceOperation*    sourceOperation );

  IDMMenuItem  ( const IDMItem::Handle& dragItem );

virtual
  ~IDMMenuItem ( );


/*--------------------------- Menu Item Operations ---------------------------*/
virtual unsigned long
  supportedOperationsFor ( const IString& selectedRMFs ) const;

/*------------------------------ Menu Cleanup --------------------------------*/
virtual Boolean
  sourceEnd ( IDMSourceEndEvent& event );

/*------------------------------ Source Items --------------------------------*/
static Boolean
  generateSourceItems ( IDMSourceOperation* sourceOperation );

private:
/*--------------------------------- Private ----------------------------------*/
Boolean
  fNoDismiss;

IDMMenuItem
 &dismissMenu ( );

IDMMenuItemData
 *fDMMenuItemData;

}; // IDMMenuItem

#pragma pack()
#endif // IC_WIN_FLAGNOP

#endif // _IDMMENIT_
