#ifndef _IDMMLEIT_
#define _IDMMLEIT_
/*******************************************************************************
* FILE NAME: idmmleit.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMMLEItem                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <idmitem.hpp>

class IDMSourceOperation;
class IDMMLEItemData;

#pragma pack(4)

class IDMMLEItem : public IDMItem {
typedef IDMItem
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMMLEItem  ( IDMSourceOperation*    sourceOperation );

  IDMMLEItem  ( const IDMItem::Handle& dragItem );

virtual
  ~IDMMLEItem ( );


/*------------------------------ Source Items --------------------------------*/
static Boolean
  generateSourceItems ( IDMSourceOperation* sourceOperation );

virtual void
 *object              ( ) const;

/*------------------------------ Drop Processing -----------------------------*/
virtual Boolean
  sourceEnd  ( IDMSourceEndEvent&  event ),
  targetDrop ( IDMTargetDropEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/

IDMMLEItemData
 *fDMMLEItemData;

}; // IDMMLEItem

#pragma pack()

#endif // _IDMMLEIT_
